/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.opencsv.CSVWriter;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.csv.CsvWriteOptions;

@Immutable
public final class CsvWriter {
    private CsvWriter() {
    }

    public static void write(Table table, CsvWriteOptions options) throws IOException {
        try (CSVWriter csvWriter = new CSVWriter(options.writer(), options.separator(), options.quoteChar(), options.escapeChar(), options.lineEnd());){
            if (options.header()) {
                String[] header = new String[table.columnCount()];
                for (int c = 0; c < table.columnCount(); ++c) {
                    header[c] = table.column(c).name();
                }
                csvWriter.writeNext(header);
            }
            for (int r = 0; r < table.rowCount(); ++r) {
                String[] entries = new String[table.columnCount()];
                for (int c = 0; c < table.columnCount(); ++c) {
                    table.get(r, c);
                    entries[c] = table.get(r, c);
                }
                csvWriter.writeNext(entries);
            }
        }
    }
}

