/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public enum ColumnType {
    BOOLEAN(Byte.valueOf((byte)-128), 1, "Boolean"),
    STRING((Comparable<?>)((Object)""), 4, "String"),
    NUMBER(Double.valueOf(Double.NaN), 8, "Number"),
    LOCAL_DATE(Integer.valueOf(Integer.MIN_VALUE), 4, "Date"),
    LOCAL_DATE_TIME(Long.valueOf(Long.MIN_VALUE), 8, "DateTime"),
    LOCAL_TIME(Integer.valueOf(Integer.MIN_VALUE), 4, "Time"),
    SKIP(null, 0, "Skipped");

    private final Comparable<?> missingValue;
    private final int byteSize;
    private final String printerFriendlyName;

    private ColumnType(Comparable<?> missingValue, int byteSize, String name) {
        this.missingValue = missingValue;
        this.byteSize = byteSize;
        this.printerFriendlyName = name;
    }

    public Column create(String name) {
        switch (this) {
            case BOOLEAN: {
                return BooleanColumn.create(name);
            }
            case STRING: {
                return StringColumn.create(name);
            }
            case NUMBER: {
                return DoubleColumn.create(name);
            }
            case LOCAL_DATE: {
                return DateColumn.create(name);
            }
            case LOCAL_DATE_TIME: {
                return DateTimeColumn.create(name);
            }
            case LOCAL_TIME: {
                return TimeColumn.create(name);
            }
            case SKIP: {
                throw new IllegalArgumentException("Cannot create column of type SKIP");
            }
        }
        throw new UnsupportedOperationException("Column type " + this.name() + " doesn't support column creation");
    }

    public Comparable<?> getMissingValue() {
        return this.missingValue;
    }

    public int byteSize() {
        return this.byteSize;
    }

    public String getPrinterFriendlyName() {
        return this.printerFriendlyName;
    }
}

