/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.selection.Selection;

@Immutable
public class Rows {
    private Rows() {
    }

    public static void copyRowsToTable(IntArrayList rows, Table oldTable, Table newTable) {
        block8: for (int columnIndex = 0; columnIndex < oldTable.columnCount(); ++columnIndex) {
            ColumnType columnType = oldTable.column(columnIndex).type();
            switch (columnType) {
                case STRING: {
                    Rows.copy(rows, (StringColumn)oldTable.column(columnIndex), (StringColumn)newTable.column(columnIndex));
                    continue block8;
                }
                case BOOLEAN: {
                    Rows.copy(rows, (BooleanColumn)oldTable.column(columnIndex), (BooleanColumn)newTable.column(columnIndex));
                    continue block8;
                }
                case NUMBER: {
                    Rows.copy(rows, (NumberColumn)oldTable.column(columnIndex), (NumberColumn)newTable.column(columnIndex));
                    continue block8;
                }
                case LOCAL_DATE: {
                    Rows.copy(rows, (DateColumn)oldTable.column(columnIndex), (DateColumn)newTable.column(columnIndex));
                    continue block8;
                }
                case LOCAL_DATE_TIME: {
                    Rows.copy(rows, (DateTimeColumn)oldTable.column(columnIndex), (DateTimeColumn)newTable.column(columnIndex));
                    continue block8;
                }
                case LOCAL_TIME: {
                    Rows.copy(rows, (TimeColumn)oldTable.column(columnIndex), (TimeColumn)newTable.column(columnIndex));
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unhandled column type in case statement");
                }
            }
        }
    }

    public static void appendRowToTable(int row, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList();
        rows.add(row);
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static boolean compareRows(int rowInOriginal, Table original, Table tempTable) {
        block8: for (int columnIndex = 0; columnIndex < original.columnCount(); ++columnIndex) {
            ColumnType columnType = original.column(columnIndex).type();
            switch (columnType) {
                case NUMBER: {
                    boolean result = Rows.compare(rowInOriginal, (NumberColumn)tempTable.column(columnIndex), (NumberColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                case STRING: {
                    boolean result = Rows.compare(rowInOriginal, (StringColumn)tempTable.column(columnIndex), (StringColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                case BOOLEAN: {
                    boolean result = Rows.compare(rowInOriginal, (BooleanColumn)tempTable.column(columnIndex), (BooleanColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                case LOCAL_DATE: {
                    boolean result = Rows.compare(rowInOriginal, (DateColumn)tempTable.column(columnIndex), (DateColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                case LOCAL_DATE_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (DateTimeColumn)tempTable.column(columnIndex), (DateTimeColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                case LOCAL_TIME: {
                    boolean result = Rows.compare(rowInOriginal, (TimeColumn)tempTable.column(columnIndex), (TimeColumn)original.column(columnIndex));
                    if (result) continue block8;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unhandled column type in case statement");
                }
            }
        }
        return true;
    }

    public static void copyRowsToTable(Selection rows, Table oldTable, Table newTable) {
        int[] r = rows.toArray();
        IntArrayList rowArray = new IntArrayList(r);
        Rows.copyRowsToTable(rowArray, oldTable, newTable);
    }

    public static void head(int rowCount, Table oldTable, Table newTable) {
        IntArrayList rows = new IntArrayList(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    public static void tail(int rowsToInclude, Table oldTable, Table newTable) {
        int oldTableSize = oldTable.rowCount();
        int start = oldTableSize - rowsToInclude;
        IntArrayList rows = new IntArrayList(rowsToInclude);
        for (int i = start; i < oldTableSize; ++i) {
            rows.add(i);
        }
        Rows.copyRowsToTable(rows, oldTable, newTable);
    }

    private static void copy(IntArrayList rows, NumberColumn oldColumn, NumberColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, NumberColumn tempTable, NumberColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, StringColumn oldColumn, StringColumn newColumn) {
        newColumn.initializeWith(oldColumn.getValues(rows), oldColumn);
    }

    private static boolean compare(int row, StringColumn tempTable, StringColumn original) {
        String t = tempTable.get(tempTable.size() - 1);
        String o = original.get(row);
        return o.equals(t);
    }

    private static void copy(IntArrayList rows, BooleanColumn oldColumn, BooleanColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.append(oldColumn.get(index));
        }
    }

    private static boolean compare(int row, BooleanColumn tempTable, BooleanColumn original) {
        return original.get(row) == tempTable.get(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, DateTimeColumn oldColumn, DateTimeColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.appendInternal(oldColumn.getLongInternal(index));
        }
    }

    private static boolean compare(int row, DateTimeColumn tempTable, DateTimeColumn original) {
        return original.getLongInternal(row) == tempTable.getLongInternal(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, DateColumn oldColumn, DateColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.appendInternal(oldColumn.getIntInternal(index));
        }
    }

    private static boolean compare(int row, DateColumn tempTable, DateColumn original) {
        return original.getIntInternal(row) == tempTable.getIntInternal(tempTable.size() - 1);
    }

    private static void copy(IntArrayList rows, TimeColumn oldColumn, TimeColumn newColumn) {
        IntListIterator intListIterator = rows.iterator();
        while (intListIterator.hasNext()) {
            int index = (Integer)intListIterator.next();
            newColumn.appendInternal(oldColumn.getIntInternal(index));
        }
    }

    private static boolean compare(int row, TimeColumn tempTable, TimeColumn original) {
        return original.getIntInternal(row) == tempTable.getIntInternal(tempTable.size() - 1);
    }
}

