/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.sorting.comparators;

import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;

public class IntComparatorChain
implements IntComparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<IntComparator> comparatorChain = new ArrayList<IntComparator>(1);
    private BitSet orderingBits = null;
    private boolean isLocked = false;

    public IntComparatorChain(IntComparator comparator) {
        this(comparator, false);
    }

    private IntComparatorChain(IntComparator comparator, boolean reverse) {
        this.comparatorChain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (reverse) {
            this.orderingBits.set(0);
        }
    }

    public void addComparator(IntComparator comparator) {
        this.addComparator(comparator, false);
    }

    private void addComparator(IntComparator comparator, boolean reverse) {
        this.comparatorChain.add(comparator);
        if (reverse) {
            this.orderingBits.set(this.comparatorChain.size() - 1);
        }
    }

    public int size() {
        return this.comparatorChain.size();
    }

    private void checkChainIntegrity() {
        if (this.comparatorChain.size() == 0) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }

    public int compare(int o1, int o2) throws UnsupportedOperationException {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
        Iterator<IntComparator> comparators = this.comparatorChain.iterator();
        int comparatorIndex = 0;
        while (comparators.hasNext()) {
            IntComparator comparator = comparators.next();
            int retval = comparator.compare(o1, o2);
            if (retval != 0) {
                if (this.orderingBits.get(comparatorIndex)) {
                    retval = retval > 0 ? -1 : 1;
                }
                return retval;
            }
            ++comparatorIndex;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 0;
        if (null != this.comparatorChain) {
            hash ^= this.comparatorChain.hashCode();
        }
        if (null != this.orderingBits) {
            hash ^= this.orderingBits.hashCode();
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        IntComparatorChain chain = (IntComparatorChain)object;
        return !(null != this.orderingBits ? !this.orderingBits.equals(chain.orderingBits) : null != chain.orderingBits) && (null == this.comparatorChain ? null == chain.comparatorChain : this.comparatorChain.equals(chain.comparatorChain));
        {
        }
    }
}

