/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringPredicates;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface StringFilters
extends Column {
    default public Selection eval(BiPredicate<String, String> predicate, StringColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), otherColumn.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, String> predicate, String value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, Integer> predicate, Integer value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<String> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection equalsIgnoreCase(String string) {
        return this.eval(StringPredicates.isEqualToIgnoringCase, string);
    }

    default public Selection isEmptyString() {
        return this.eval(StringPredicates.isEmpty);
    }

    default public Selection startsWith(String string) {
        return this.eval(StringPredicates.startsWith, string);
    }

    default public Selection endsWith(String string) {
        return this.eval(StringPredicates.endsWith, string);
    }

    default public Selection containsString(String string) {
        return this.eval(StringPredicates.stringContains, string);
    }

    default public Selection matchesRegex(String string) {
        return this.eval(StringPredicates.matchesRegex, string);
    }

    default public Selection isAlpha() {
        return this.eval(StringPredicates.isAlpha);
    }

    default public Selection isNumeric() {
        return this.eval(StringPredicates.isNumeric);
    }

    default public Selection isAlphaNumeric() {
        return this.eval(StringPredicates.isAlphaNumeric);
    }

    default public Selection isUpperCase() {
        return this.eval(StringPredicates.isUpperCase);
    }

    default public Selection isLowerCase() {
        return this.eval(StringPredicates.isLowerCase);
    }

    default public Selection lengthEquals(int stringLength) {
        return this.eval(StringPredicates.hasEqualLengthTo, stringLength);
    }

    default public Selection isShorterThan(int stringLength) {
        return this.eval(StringPredicates.isShorterThan, stringLength);
    }

    default public Selection isLongerThan(int stringLength) {
        return this.eval(StringPredicates.isLongerThan, stringLength);
    }

    public Selection isIn(String ... var1);

    default public Selection isIn(Collection<String> strings) {
        return this.isIn(strings.toArray(new String[0]));
    }

    public Selection isNotIn(String ... var1);

    default public Selection isNotIn(Collection<String> strings) {
        return this.isNotIn(strings.toArray(new String[0]));
    }

    default public Selection isEqualTo(StringColumn other) {
        return this.eval(StringPredicates.isEqualTo, other);
    }

    default public Selection isNotEqualTo(StringColumn other) {
        return this.eval(StringPredicates.isNotEqualTo, other);
    }

    default public Selection equalsIgnoreCase(StringColumn other) {
        return this.eval(StringPredicates.isEqualToIgnoringCase, other);
    }

    default public Selection startsWith(StringColumn other) {
        return this.eval(StringPredicates.startsWith, other);
    }

    @Override
    default public Selection isMissing() {
        return this.eval(StringPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(StringPredicates.isNotMissing);
    }

    public Selection isEqualTo(String var1);

    public String get(int var1);
}

