/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.dates.PackedDate;
import tech.tablesaw.columns.datetimes.PackedDateTime;
import tech.tablesaw.columns.times.PackedTime;

public class Row
implements Iterator<Row> {
    private int rowNumber;
    private final Table table;
    private final Map<String, PackedDate> dateColumnMap = new HashMap<String, PackedDate>();
    private final Map<String, NumberColumn> numberColumnMap = new HashMap<String, NumberColumn>();
    private final Map<String, StringColumn> stringColumnMap = new HashMap<String, StringColumn>();
    private final Map<String, BooleanColumn> booleanColumnMap = new HashMap<String, BooleanColumn>();
    private final Map<String, PackedDateTime> dateTimeColumnMap = new HashMap<String, PackedDateTime>();
    private final Map<String, PackedTime> timeColumnMap = new HashMap<String, PackedTime>();

    public Row(Table table) {
        this.table = table;
        this.rowNumber = -1;
        for (Column column : table.columns()) {
            if (column instanceof DateColumn) {
                this.dateColumnMap.put(column.name(), new PackedDate((DateColumn)column));
                continue;
            }
            if (column instanceof DoubleColumn) {
                this.numberColumnMap.put(column.name(), (NumberColumn)column);
                continue;
            }
            if (column instanceof StringColumn) {
                this.stringColumnMap.put(column.name(), (StringColumn)column);
                continue;
            }
            if (column instanceof BooleanColumn) {
                this.booleanColumnMap.put(column.name(), (BooleanColumn)column);
                continue;
            }
            if (column instanceof DateTimeColumn) {
                this.dateTimeColumnMap.put(column.name(), new PackedDateTime((DateTimeColumn)column));
                continue;
            }
            if (column instanceof TimeColumn) {
                this.timeColumnMap.put(column.name(), new PackedTime((TimeColumn)column));
                continue;
            }
            throw new RuntimeException("Unsupported Column type in column " + column);
        }
    }

    @Override
    public boolean hasNext() {
        return this.rowNumber < this.table.rowCount() - 1;
    }

    public List<String> columnNames() {
        return this.table.columnNames();
    }

    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public Row next() {
        ++this.rowNumber;
        return this;
    }

    public double getDouble(String columnName) {
        return this.numberColumnMap.get(columnName).get(this.rowNumber);
    }

    public int getInt(String columnName) {
        return (int)this.numberColumnMap.get(columnName).get(this.rowNumber);
    }

    public String getString(String columnName) {
        return this.stringColumnMap.get(columnName).get(this.rowNumber);
    }

    public LocalDate getDate(String columnName) {
        return this.getPackedDate(columnName).asLocalDate();
    }

    public PackedDate getPackedDate(String columnName) {
        return this.dateColumnMap.get(columnName).get(this.rowNumber);
    }

    public LocalTime getTime(String columnName) {
        return this.getPackedTime(columnName).asLocalTime();
    }

    public LocalDateTime getDateTime(String columnName) {
        return this.getPackedDateTime(columnName).asLocalDateTime();
    }

    public PackedTime getPackedTime(String columnName) {
        return this.timeColumnMap.get(columnName).get(this.rowNumber);
    }

    public PackedDateTime getPackedDateTime(String columnName) {
        return this.dateTimeColumnMap.get(columnName).get(this.rowNumber);
    }

    public boolean getBoolean(String columnName) {
        return this.booleanColumnMap.get(columnName).get(this.rowNumber);
    }

    public double getDouble(int columnIndex) {
        return this.numberColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public int getInt(int columnIndex) {
        return (int)this.numberColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public String getString(int columnIndex) {
        return this.stringColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public LocalDate getDate(int columnIndex) {
        return this.getPackedDate(this.columnNames().get(columnIndex)).asLocalDate();
    }

    public PackedDate getPackedDate(int columnIndex) {
        return this.dateColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public LocalTime getTime(int columnIndex) {
        return this.getPackedTime(this.columnNames().get(columnIndex)).asLocalTime();
    }

    public LocalDateTime getDateTime(int columnIndex) {
        return this.getPackedDateTime(this.columnNames().get(columnIndex)).asLocalDateTime();
    }

    public PackedTime getPackedTime(int columnIndex) {
        return this.timeColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public PackedDateTime getPackedDateTime(int columnIndex) {
        return this.dateTimeColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public boolean getBoolean(int columnIndex) {
        return this.booleanColumnMap.get(this.columnNames().get(columnIndex)).get(this.rowNumber);
    }

    public void at(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String toString() {
        Table t = this.table.emptyCopy();
        if (this.getRowNumber() == -1) {
            return "";
        }
        t.addRow(this);
        return t.print();
    }
}

