/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.selection;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntIterable;
import java.util.BitSet;
import org.apache.commons.lang3.RandomUtils;
import org.roaringbitmap.RoaringBitmap;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.selection.BitmapBackedSelection;

public interface Selection
extends IntIterable,
Filter {
    public static Selection with(int ... rows) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int i : rows) {
            selection.add(i);
        }
        return selection;
    }

    public static Selection withRange(int start, int end) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(start, end);
        return selection;
    }

    public static Selection withoutRange(int totalRangeStart, int totalRangeEnd, int excludedRangeStart, int excludedRangeEnd) {
        Preconditions.checkArgument((excludedRangeStart >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd <= totalRangeEnd ? 1 : 0) != 0);
        Preconditions.checkArgument((totalRangeEnd >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd >= excludedRangeStart ? 1 : 0) != 0);
        Selection selection = Selection.withRange(totalRangeStart, totalRangeEnd);
        Selection exclusion = Selection.withRange(excludedRangeStart, excludedRangeEnd);
        selection.andNot(exclusion);
        return selection;
    }

    public int[] toArray();

    public RoaringBitmap toBitmapInternal();

    public Selection add(int ... var1);

    public Selection addRange(int var1, int var2);

    public Selection removeRange(long var1, long var3);

    public int size();

    public Selection and(Selection var1);

    public Selection or(Selection var1);

    public Selection andNot(Selection var1);

    public boolean isEmpty();

    public Selection clear();

    public boolean contains(int var1);

    public int get(int var1);

    public Selection flip(int var1, int var2);

    @Override
    default public Selection apply(Table relation) {
        return this;
    }

    @Override
    default public Selection apply(Column columnBeingFiltered) {
        return this;
    }

    public static int[] generateUniformBitmap(int N, int Max) {
        if (N > Max) {
            throw new IllegalArgumentException("Illegal arguments: N (" + N + ") greater than Max (" + Max + ")");
        }
        int[] ans = new int[N];
        if (N == Max) {
            for (int k = 0; k < N; ++k) {
                ans[k] = k;
            }
            return ans;
        }
        BitSet bs = new BitSet(Max);
        int cardinality = 0;
        while (cardinality < N) {
            int v = RandomUtils.nextInt((int)0, (int)Max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ans[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        return ans;
    }

    public static Selection selectNRowsAtRandom(int n, int max) {
        int[] selectedRecords;
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int selectedRecord : selectedRecords = Selection.generateUniformBitmap(n, max)) {
            selection.add(selectedRecord);
        }
        return selection;
    }
}

