/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.selection;

import it.unimi.dsi.fastutil.ints.IntIterator;
import org.roaringbitmap.RoaringBitmap;
import tech.tablesaw.selection.Selection;

public class BitmapBackedSelection
implements Selection {
    private final RoaringBitmap bitmap;

    public BitmapBackedSelection(int size) {
        this.bitmap = new RoaringBitmap();
        this.addRange(0, size);
    }

    public BitmapBackedSelection(RoaringBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public BitmapBackedSelection() {
        this.bitmap = new RoaringBitmap();
    }

    @Override
    public Selection removeRange(long start, long end) {
        this.bitmap.remove(start, end);
        return this;
    }

    @Override
    public Selection flip(int rangeStart, int rangeEnd) {
        this.bitmap.flip((long)rangeStart, (long)rangeEnd);
        return this;
    }

    @Override
    public Selection add(int ... ints) {
        this.bitmap.add(ints);
        return this;
    }

    public String toString() {
        return "Selection of size: " + this.bitmap.getCardinality();
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public int[] toArray() {
        return this.bitmap.toArray();
    }

    @Override
    public RoaringBitmap toBitmapInternal() {
        return this.bitmap.clone();
    }

    @Override
    public Selection and(Selection otherSelection) {
        this.bitmap.and(otherSelection.toBitmapInternal());
        return this;
    }

    @Override
    public Selection or(Selection otherSelection) {
        this.bitmap.or(otherSelection.toBitmapInternal());
        return this;
    }

    @Override
    public Selection andNot(Selection otherSelection) {
        this.bitmap.andNot(otherSelection.toBitmapInternal());
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Selection clear() {
        this.bitmap.clear();
        return this;
    }

    @Override
    public boolean contains(int i) {
        return this.bitmap.contains(i);
    }

    @Override
    public Selection addRange(int start, int end) {
        this.bitmap.add((long)start, (long)end);
        return this;
    }

    @Override
    public int get(int i) {
        return this.bitmap.select(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapBackedSelection integers = (BitmapBackedSelection)o;
        return this.bitmap.equals((Object)integers.bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private final org.roaringbitmap.IntIterator iterator;
            {
                this.iterator = BitmapBackedSelection.this.bitmap.getIntIterator();
            }

            public int nextInt() {
                return this.iterator.next();
            }

            public int skip(int k) {
                throw new UnsupportedOperationException("Views do not support skipping in the iterator");
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }
}

