/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import com.google.common.base.Preconditions;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.selection.Selection;

public abstract class TwoColumnFilter
implements Filter {
    private final ColumnReference columnReference;
    private Column otherColumn;
    private ColumnReference otherColumnReference;

    public TwoColumnFilter(ColumnReference reference, Column otherColumn) {
        this.columnReference = reference;
        this.otherColumn = otherColumn;
    }

    public TwoColumnFilter(Column columnToCompareAgainst) {
        this.columnReference = null;
        Preconditions.checkNotNull((Object)columnToCompareAgainst);
        this.otherColumn = columnToCompareAgainst;
    }

    public TwoColumnFilter(ColumnReference reference, ColumnReference columnToCompareAgainst) {
        this.columnReference = reference;
        Preconditions.checkNotNull((Object)columnToCompareAgainst);
        this.otherColumnReference = columnToCompareAgainst;
    }

    @Override
    public Selection apply(Table relation) {
        if (this.otherColumn == null) {
            this.otherColumn = relation.column(this.otherColumnReference.getColumnName());
        }
        return this.apply(relation.column(this.columnReference().getColumnName()));
    }

    public ColumnReference columnReference() {
        return this.columnReference;
    }

    public ColumnReference otherColumnReference() {
        return this.otherColumnReference;
    }

    public Column otherColumn() {
        Preconditions.checkNotNull((Object)this.otherColumn, (Object)"Column references can only be used in multi-column filters when both columns are in the same table, and the apply(table) method is used.");
        return this.otherColumn;
    }
}

