/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.times.filters;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

public class IsAfterNoon
extends ColumnFilter {
    public IsAfterNoon(ColumnReference reference) {
        super(reference);
    }

    @Override
    public Selection apply(Table relation) {
        String name = this.columnReference().getColumnName();
        Column column = relation.column(name);
        return this.apply(column);
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        ColumnType type = columnBeingFiltered.type();
        switch (type) {
            case LOCAL_TIME: {
                TimeColumn timeColumn = (TimeColumn)columnBeingFiltered;
                return timeColumn.eval(PackedLocalTime::PM);
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)columnBeingFiltered;
                return dateTimeColumn.eval(PackedLocalDateTime::PM);
            }
        }
        throw new UnsupportedOperationException("Columns of type " + type.name() + " do not support the operation isAfterNoon() ");
    }
}

