/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings.filters;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class NotEqualTo
extends ColumnFilter {
    private final String value;

    public NotEqualTo(StringColumnReference reference, String value) {
        super(reference);
        this.value = value;
    }

    @Override
    public Selection apply(Table relation) {
        Column column = relation.column(this.columnReference().getColumnName());
        return this.apply(column);
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        ColumnType type = columnBeingFiltered.type();
        switch (type) {
            case STRING: {
                StringColumn stringColumn = (StringColumn)columnBeingFiltered;
                BitmapBackedSelection selection = new BitmapBackedSelection();
                selection.addRange(0, stringColumn.size());
                selection.andNot(stringColumn.isEqualTo(this.value));
                return selection;
            }
        }
        throw new UnsupportedOperationException(String.format("ColumnType %s does not support equalTo on a String value", new Object[]{type}));
    }
}

