/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings.filters;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

public class EqualTo
extends ColumnFilter {
    private final String value;

    public EqualTo(StringColumnReference reference, String value) {
        super(reference);
        this.value = value;
    }

    @Override
    public Selection apply(Table relation) {
        return this.apply(relation.column(this.columnReference().getColumnName()));
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        ColumnType type = columnBeingFiltered.type();
        switch (type) {
            case STRING: {
                StringColumn stringColumn = (StringColumn)columnBeingFiltered;
                return stringColumn.isEqualTo(this.value);
            }
        }
        throw new UnsupportedOperationException(String.format("ColumnType %s does not support equalTo on a String value", new Object[]{type}));
    }
}

