/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.StringColumnReference;
import tech.tablesaw.columns.strings.StringPredicates;
import tech.tablesaw.columns.strings.filters.ColumnEqualTo;
import tech.tablesaw.columns.strings.filters.ColumnEqualToIgnoringCase;
import tech.tablesaw.columns.strings.filters.ColumnNotEqualTo;
import tech.tablesaw.columns.strings.filters.ContainsString;
import tech.tablesaw.columns.strings.filters.EndsWith;
import tech.tablesaw.columns.strings.filters.EqualToIgnoringCase;
import tech.tablesaw.columns.strings.filters.HasLengthEqualTo;
import tech.tablesaw.columns.strings.filters.IsAlpha;
import tech.tablesaw.columns.strings.filters.IsAlphaNumeric;
import tech.tablesaw.columns.strings.filters.IsLongerThan;
import tech.tablesaw.columns.strings.filters.IsLowerCase;
import tech.tablesaw.columns.strings.filters.IsNumeric;
import tech.tablesaw.columns.strings.filters.IsShorterThan;
import tech.tablesaw.columns.strings.filters.IsUpperCase;
import tech.tablesaw.columns.strings.filters.MatchesRegex;
import tech.tablesaw.columns.strings.filters.StartsWith;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface StringFilters
extends Column {
    public StringColumn where(Filter var1);

    default public Selection eval(BiPredicate<String, String> predicate, StringColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), otherColumn.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, String> predicate, String value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<String, Integer> predicate, Integer value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<String> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection equalsIgnoreCase(String string) {
        return new EqualToIgnoringCase(new StringColumnReference(this.name()), string).apply(this);
    }

    default public Selection isEmptyString() {
        return this.eval(String::isEmpty);
    }

    default public Selection startsWith(String string) {
        return new StartsWith(new StringColumnReference(this.name()), string).apply(this);
    }

    default public Selection endsWith(String string) {
        return new EndsWith(new StringColumnReference(this.name()), string).apply(this);
    }

    default public Selection containsString(String string) {
        return new ContainsString(new StringColumnReference(this.name()), string).apply(this);
    }

    default public Selection matchesRegex(String string) {
        return new MatchesRegex(new StringColumnReference(this.name()), string).apply(this);
    }

    default public Selection isAlpha() {
        return new IsAlpha(new StringColumnReference(this.name())).apply(this);
    }

    default public Selection isNumeric() {
        return new IsNumeric(new StringColumnReference(this.name())).apply(this);
    }

    default public Selection isAlphaNumeric() {
        return new IsAlphaNumeric(new StringColumnReference(this.name())).apply(this);
    }

    default public Selection isUpperCase() {
        return new IsUpperCase(new StringColumnReference(this.name())).apply(this);
    }

    default public Selection isLowerCase() {
        return new IsLowerCase(new StringColumnReference(this.name())).apply(this);
    }

    default public Selection lengthEquals(int stringLength) {
        return new HasLengthEqualTo(new StringColumnReference(this.name()), stringLength).apply(this);
    }

    default public Selection isShorterThan(int stringLength) {
        return new IsShorterThan(new StringColumnReference(this.name()), stringLength).apply(this);
    }

    default public Selection isLongerThan(int stringLength) {
        return new IsLongerThan(new StringColumnReference(this.name()), stringLength).apply(this);
    }

    public Selection isIn(String ... var1);

    default public Selection isIn(Collection<String> strings) {
        return this.isIn(strings.toArray(new String[strings.size()]));
    }

    public Selection isNotIn(String ... var1);

    default public Selection isNotIn(Collection<String> strings) {
        return this.isNotIn(strings.toArray(new String[strings.size()]));
    }

    default public Selection isEqualTo(StringColumn other) {
        return new ColumnEqualTo(other).apply(this);
    }

    default public Selection isNotEqualTo(StringColumn other) {
        return new ColumnNotEqualTo(other).apply(this);
    }

    default public Selection equalsIgnoreCase(StringColumn other) {
        return new ColumnEqualToIgnoringCase(other).apply(this);
    }

    @Override
    default public Selection isMissing() {
        return this.eval(StringPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(StringPredicates.isNotMissing);
    }

    public Selection isEqualTo(String var1);

    public String get(int var1);
}

