/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.List;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.strings.filters.ColumnContainsString;
import tech.tablesaw.columns.strings.filters.ColumnEndsWith;
import tech.tablesaw.columns.strings.filters.ColumnEqualTo;
import tech.tablesaw.columns.strings.filters.ColumnEqualToIgnoringCase;
import tech.tablesaw.columns.strings.filters.ColumnNotEqualTo;
import tech.tablesaw.columns.strings.filters.ColumnStartsWith;
import tech.tablesaw.columns.strings.filters.ContainsString;
import tech.tablesaw.columns.strings.filters.EndsWith;
import tech.tablesaw.columns.strings.filters.EqualTo;
import tech.tablesaw.columns.strings.filters.EqualToIgnoringCase;
import tech.tablesaw.columns.strings.filters.HasLengthEqualTo;
import tech.tablesaw.columns.strings.filters.IsAlpha;
import tech.tablesaw.columns.strings.filters.IsAlphaNumeric;
import tech.tablesaw.columns.strings.filters.IsEmptyString;
import tech.tablesaw.columns.strings.filters.IsIn;
import tech.tablesaw.columns.strings.filters.IsLongerThan;
import tech.tablesaw.columns.strings.filters.IsLowerCase;
import tech.tablesaw.columns.strings.filters.IsNotIn;
import tech.tablesaw.columns.strings.filters.IsNumeric;
import tech.tablesaw.columns.strings.filters.IsShorterThan;
import tech.tablesaw.columns.strings.filters.IsUpperCase;
import tech.tablesaw.columns.strings.filters.MatchesRegex;
import tech.tablesaw.columns.strings.filters.NotEqualTo;
import tech.tablesaw.columns.strings.filters.StartsWith;
import tech.tablesaw.filtering.Filter;

public class StringColumnReference
extends ColumnReference {
    public StringColumnReference(String column) {
        super(column);
    }

    public Filter isEqualTo(String value) {
        return new EqualTo(this, value);
    }

    public Filter isNotEqualTo(String value) {
        return new NotEqualTo(this, value);
    }

    public Filter isIn(String ... strings) {
        return new IsIn(this, strings);
    }

    public Filter isNotIn(String ... strings) {
        return new IsNotIn(this, strings);
    }

    public Filter isIn(List<String> strings) {
        return new IsIn(this, strings);
    }

    public Filter isNotIn(List<String> strings) {
        return new IsNotIn(this, strings);
    }

    public Filter isUpperCase() {
        return new IsUpperCase(this);
    }

    public Filter isLowerCase() {
        return new IsLowerCase(this);
    }

    public Filter isAlpha() {
        return new IsAlpha(this);
    }

    public Filter isAlphaNumeric() {
        return new IsAlphaNumeric(this);
    }

    public Filter isNumeric() {
        return new IsNumeric(this);
    }

    public Filter isEmptyString() {
        return new IsEmptyString(this);
    }

    public Filter isLongerThan(int length) {
        return new IsLongerThan(this, length);
    }

    public Filter isShorterThan(int length) {
        return new IsShorterThan(this, length);
    }

    public Filter lengthEquals(int length) {
        return new HasLengthEqualTo(this, length);
    }

    public Filter equalsIgnoreCase(String string) {
        return new EqualToIgnoringCase(this, string);
    }

    public Filter startsWith(String string) {
        return new StartsWith(this, string);
    }

    public Filter endsWith(String string) {
        return new EndsWith(this, string);
    }

    public Filter containsString(String string) {
        return new ContainsString(this, string);
    }

    public Filter containsString(StringColumn sc) {
        return new ColumnContainsString(this, sc);
    }

    public Filter matchesRegex(String string) {
        return new MatchesRegex(this, string);
    }

    public Filter startsWith(StringColumn sc) {
        return new ColumnStartsWith(this, sc);
    }

    public Filter startsWith(StringColumnReference ref) {
        return new ColumnStartsWith(this, ref);
    }

    public Filter endsWith(StringColumn sc) {
        return new ColumnEndsWith(this, sc);
    }

    public Filter endsWith(StringColumnReference ref) {
        return new ColumnEndsWith(this, ref);
    }

    public Filter isEqualTo(StringColumn value) {
        return new ColumnEqualTo(this, value);
    }

    public Filter isEqualTo(StringColumnReference value) {
        return new ColumnEqualTo(this, value);
    }

    public Filter isNotEqualTo(StringColumn value) {
        return new ColumnNotEqualTo(this, value);
    }

    public Filter isNotEqualTo(StringColumnReference value) {
        return new ColumnNotEqualTo(this, value);
    }

    public Filter equalsIgnoreCase(StringColumn stringColumnToCompareAgainst) {
        return new ColumnEqualToIgnoringCase(this, stringColumnToCompareAgainst);
    }

    public Filter equalsIgnoreCase(StringColumnReference stringColumnToCompareAgainst) {
        return new ColumnEqualToIgnoringCase(this, stringColumnToCompareAgainst);
    }
}

