/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers.filters;

import java.util.List;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

public class IsNotIn
extends ColumnFilter {
    private final double[] doubles;

    public IsNotIn(ColumnReference reference, List<Number> values) {
        super(reference);
        this.doubles = values.stream().mapToDouble(Number::doubleValue).toArray();
    }

    public IsNotIn(ColumnReference reference, double ... values) {
        super(reference);
        this.doubles = values;
    }

    @Override
    public Selection apply(Table relation) {
        return this.apply(relation.column(this.columnReference().getColumnName()));
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        NumberColumn numberColumn = (NumberColumn)columnBeingFiltered;
        return numberColumn.isNotIn(this.doubles);
    }
}

