/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.numbers.filters.BetweenExclusive;
import tech.tablesaw.columns.numbers.filters.BetweenInclusive;
import tech.tablesaw.columns.numbers.filters.ColumnEqualTo;
import tech.tablesaw.columns.numbers.filters.ColumnGreaterThan;
import tech.tablesaw.columns.numbers.filters.ColumnLessThan;
import tech.tablesaw.columns.numbers.filters.EqualTo;
import tech.tablesaw.columns.numbers.filters.GreaterThan;
import tech.tablesaw.columns.numbers.filters.GreaterThanOrEqualTo;
import tech.tablesaw.columns.numbers.filters.IsCloseTo;
import tech.tablesaw.columns.numbers.filters.IsIn;
import tech.tablesaw.columns.numbers.filters.IsNegative;
import tech.tablesaw.columns.numbers.filters.IsNonNegative;
import tech.tablesaw.columns.numbers.filters.IsNotIn;
import tech.tablesaw.columns.numbers.filters.IsPositive;
import tech.tablesaw.columns.numbers.filters.IsZero;
import tech.tablesaw.columns.numbers.filters.LessThan;
import tech.tablesaw.columns.numbers.filters.LessThanOrEqualTo;
import tech.tablesaw.columns.numbers.filters.NotEqualTo;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.filtering.IsMissing;
import tech.tablesaw.filtering.IsNotMissing;
import tech.tablesaw.filtering.composite.AnyOf;
import tech.tablesaw.filtering.composite.IsFalse;

public class NumberColumnReference
extends ColumnReference {
    public NumberColumnReference(String columnName) {
        super(columnName);
    }

    public Filter isEqualTo(Number value) {
        return new EqualTo(this, value);
    }

    public Filter isEqualTo(NumberColumn value) {
        return new ColumnEqualTo((ColumnReference)this, value);
    }

    public Filter isEqualTo(NumberColumnReference value) {
        return new ColumnEqualTo((ColumnReference)this, value);
    }

    public Filter isGreaterThan(Number value) {
        return new GreaterThan(this, value);
    }

    public Filter isGreaterThan(NumberColumn value) {
        return new ColumnGreaterThan((ColumnReference)this, value);
    }

    public Filter isGreaterThan(NumberColumnReference value) {
        return new ColumnGreaterThan((ColumnReference)this, value);
    }

    public Filter isGreaterThanOrEqualTo(Number value) {
        return new GreaterThanOrEqualTo(this, value);
    }

    public Filter isGreaterThanOrEqualTo(NumberColumn value) {
        return AnyOf.anyOf(this.isGreaterThan(value), this.isEqualTo(value));
    }

    public Filter isGreaterThanOrEqualTo(NumberColumnReference value) {
        return AnyOf.anyOf(this.isGreaterThan(value), this.isEqualTo(value));
    }

    public Filter isLessThan(Number value) {
        return new LessThan(this, value);
    }

    public Filter isLessThan(NumberColumn value) {
        return new ColumnLessThan((ColumnReference)this, value);
    }

    public Filter isLessThan(NumberColumnReference value) {
        return new ColumnLessThan((ColumnReference)this, value);
    }

    public Filter isLessThanOrEqualTo(Number value) {
        return new LessThanOrEqualTo(this, value);
    }

    public Filter isLessThanOrEqualTo(NumberColumn value) {
        return AnyOf.anyOf(this.isLessThan(value), this.isEqualTo(value));
    }

    public Filter isLessThanOrEqualTo(NumberColumnReference value) {
        return AnyOf.anyOf(this.isLessThan(value), this.isEqualTo(value));
    }

    public Filter isNotEqualTo(Number value) {
        return new NotEqualTo(this, value);
    }

    public Filter isNotEqualTo(NumberColumn value) {
        return IsFalse.isFalse(this.isEqualTo(value));
    }

    public Filter isNotEqualTo(NumberColumnReference value) {
        return IsFalse.isFalse(this.isEqualTo(value));
    }

    public Filter isBetweenInclusive(Number low, Number high) {
        return new BetweenInclusive(this, low, high);
    }

    public Filter isBetweenExclusive(Number low, Number high) {
        return new BetweenExclusive(this, low, high);
    }

    public Filter isIn(double ... doubles) {
        return new IsIn((ColumnReference)this, doubles);
    }

    public Filter isNotIn(double ... doubles) {
        return new IsNotIn((ColumnReference)this, doubles);
    }

    @Override
    public Filter isMissing() {
        return new IsMissing(this);
    }

    public Filter isZero() {
        return new IsZero(this);
    }

    public Filter isPositive() {
        return new IsPositive(this);
    }

    public Filter isNegative() {
        return new IsNegative(this);
    }

    public Filter isNonNegative() {
        return new IsNonNegative(this);
    }

    public Filter isCloseTo(double target, double margin) {
        return new IsCloseTo(this, target, margin);
    }

    @Override
    public Filter isNotMissing() {
        return new IsNotMissing(this);
    }
}

