/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes.filters;

import java.time.LocalDateTime;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.datetimes.DateTimePredicates;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

@Immutable
public class IsOnOrAfter
extends ColumnFilter {
    private final long value;

    public IsOnOrAfter(ColumnReference reference, long value) {
        super(reference);
        this.value = value;
    }

    public IsOnOrAfter(ColumnReference reference, LocalDateTime value) {
        super(reference);
        this.value = PackedLocalDateTime.pack(value);
    }

    @Override
    public Selection apply(Table relation) {
        return this.apply(relation.column(this.columnReference().getColumnName()));
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        DateTimeColumn dateColumn = (DateTimeColumn)columnBeingFiltered;
        return dateColumn.eval(DateTimePredicates.isGreaterThanOrEqualTo, this.value);
    }
}

