/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes.filters;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

public class IsInOctober
extends ColumnFilter {
    public IsInOctober(ColumnReference reference) {
        super(reference);
    }

    @Override
    public Selection apply(Table relation) {
        String name = this.columnReference().getColumnName();
        Column column = relation.column(name);
        return this.apply(column);
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        ColumnType type = columnBeingFiltered.type();
        switch (type) {
            case LOCAL_DATE: {
                DateColumn dateColumn = (DateColumn)columnBeingFiltered;
                return dateColumn.eval(PackedLocalDate::isInOctober);
            }
            case LOCAL_DATE_TIME: {
                DateTimeColumn dateTimeColumn = (DateTimeColumn)columnBeingFiltered;
                return dateTimeColumn.eval(PackedLocalDateTime::isInOctober);
            }
        }
        throw new UnsupportedOperationException("Columns of type " + type.name() + " do not support the operation isInOctober() ");
    }
}

