/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes.filters;

import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.datetimes.DateTimePredicates;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

@Immutable
public class IsAfter
extends ColumnFilter {
    private final LocalDateTime value;

    public IsAfter(ColumnReference reference, LocalDateTime value) {
        super(reference);
        this.value = value;
    }

    public IsAfter(ColumnReference reference, LocalDate value) {
        super(reference);
        this.value = value.atStartOfDay();
    }

    @Override
    public Selection apply(Table relation) {
        return this.apply(relation.dateTimeColumn(this.columnReference().getColumnName()));
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        DateTimeColumn dateColumn = (DateTimeColumn)columnBeingFiltered;
        return dateColumn.eval(DateTimePredicates.isGreaterThan, PackedLocalDateTime.pack(this.value));
    }
}

