/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates.filters;

import java.time.LocalDate;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.selection.Selection;

public class BetweenInclusive
extends ColumnFilter {
    private final LocalDate low;
    private final LocalDate high;

    public BetweenInclusive(ColumnReference reference, LocalDate lowValue, LocalDate highValue) {
        super(reference);
        this.low = lowValue;
        this.high = highValue;
    }

    @Override
    public Selection apply(Table relation) {
        return this.apply(relation.column(this.columnReference().getColumnName()));
    }

    @Override
    public Selection apply(Column columnBeingFiltered) {
        DateColumn dateColumn = (DateColumn)columnBeingFiltered;
        int packed1 = PackedLocalDate.pack(this.low);
        Selection matches = dateColumn.eval(PackedLocalDate::isOnOrAfter, packed1);
        int packed = PackedLocalDate.pack(this.high);
        matches.and(dateColumn.eval(PackedLocalDate::isOnOrBefore, packed));
        return matches;
    }
}

