/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import java.time.LocalDate;
import java.time.LocalDateTime;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.dates.filters.BetweenExclusive;
import tech.tablesaw.columns.dates.filters.BetweenInclusive;
import tech.tablesaw.columns.dates.filters.ColumnEqualTo;
import tech.tablesaw.columns.dates.filters.ColumnIsAfter;
import tech.tablesaw.columns.dates.filters.ColumnIsBefore;
import tech.tablesaw.columns.dates.filters.ColumnNotEqualTo;
import tech.tablesaw.columns.dates.filters.EqualTo;
import tech.tablesaw.columns.dates.filters.IsAfter;
import tech.tablesaw.columns.dates.filters.IsBefore;
import tech.tablesaw.columns.datetimes.filters.IsFirstDayOfTheMonth;
import tech.tablesaw.columns.datetimes.filters.IsFriday;
import tech.tablesaw.columns.datetimes.filters.IsInApril;
import tech.tablesaw.columns.datetimes.filters.IsInAugust;
import tech.tablesaw.columns.datetimes.filters.IsInDecember;
import tech.tablesaw.columns.datetimes.filters.IsInFebruary;
import tech.tablesaw.columns.datetimes.filters.IsInJanuary;
import tech.tablesaw.columns.datetimes.filters.IsInJuly;
import tech.tablesaw.columns.datetimes.filters.IsInJune;
import tech.tablesaw.columns.datetimes.filters.IsInMarch;
import tech.tablesaw.columns.datetimes.filters.IsInMay;
import tech.tablesaw.columns.datetimes.filters.IsInNovember;
import tech.tablesaw.columns.datetimes.filters.IsInOctober;
import tech.tablesaw.columns.datetimes.filters.IsInQ1;
import tech.tablesaw.columns.datetimes.filters.IsInQ2;
import tech.tablesaw.columns.datetimes.filters.IsInQ3;
import tech.tablesaw.columns.datetimes.filters.IsInQ4;
import tech.tablesaw.columns.datetimes.filters.IsInSeptember;
import tech.tablesaw.columns.datetimes.filters.IsInYear;
import tech.tablesaw.columns.datetimes.filters.IsLastDayOfTheMonth;
import tech.tablesaw.columns.datetimes.filters.IsMonday;
import tech.tablesaw.columns.datetimes.filters.IsSaturday;
import tech.tablesaw.columns.datetimes.filters.IsSunday;
import tech.tablesaw.columns.datetimes.filters.IsThursday;
import tech.tablesaw.columns.datetimes.filters.IsTuesday;
import tech.tablesaw.columns.datetimes.filters.IsWednesday;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.filtering.composite.IsFalse;

public class DateColumnReference
extends ColumnReference {
    public DateColumnReference(String column) {
        super(column);
    }

    public Filter isEqualTo(DateColumnReference reference) {
        return new ColumnEqualTo((ColumnReference)this, reference);
    }

    public Filter isNotEqualTo(DateColumnReference reference) {
        return new ColumnNotEqualTo((ColumnReference)this, reference);
    }

    public Filter isAfter(DateColumnReference reference) {
        return new ColumnIsAfter((ColumnReference)this, reference);
    }

    public Filter isBefore(DateColumnReference reference) {
        return new ColumnIsBefore((ColumnReference)this, reference);
    }

    public Filter isOnOrBefore(DateColumnReference reference) {
        return IsFalse.isFalse(new ColumnIsAfter((ColumnReference)this, reference));
    }

    public Filter isOnOrBefore(DateColumn reference) {
        return IsFalse.isFalse(new ColumnIsAfter((ColumnReference)this, reference));
    }

    public Filter isEqualTo(DateColumn reference) {
        return new ColumnEqualTo((ColumnReference)this, reference);
    }

    public Filter isNotEqualTo(DateColumn reference) {
        return new ColumnNotEqualTo((ColumnReference)this, reference);
    }

    public Filter isAfter(DateColumn reference) {
        return new ColumnIsAfter((ColumnReference)this, reference);
    }

    public Filter isOnOrAfter(DateColumn reference) {
        return IsFalse.isFalse(new ColumnIsBefore((ColumnReference)this, reference));
    }

    public Filter isOnOrAfter(DateColumnReference reference) {
        return IsFalse.isFalse(new ColumnIsBefore((ColumnReference)this, reference));
    }

    public Filter isBefore(DateColumn reference) {
        return new ColumnIsBefore((ColumnReference)this, reference);
    }

    public Filter isBetweenIncluding(LocalDate low, LocalDate high) {
        return new BetweenInclusive(this, low, high);
    }

    public Filter isBetweenExcluding(LocalDate low, LocalDate high) {
        return new BetweenExclusive(this, low, high);
    }

    public Filter isEqualTo(LocalDate value) {
        return new EqualTo(this, value);
    }

    public Filter isBefore(LocalDateTime value) {
        return new tech.tablesaw.columns.datetimes.filters.IsBefore((ColumnReference)this, value);
    }

    public Filter isAfter(LocalDateTime value) {
        return new tech.tablesaw.columns.datetimes.filters.IsAfter((ColumnReference)this, value);
    }

    public Filter isBefore(LocalDate date) {
        return new IsBefore(this, PackedLocalDate.pack(date));
    }

    public Filter isAfter(LocalDate date) {
        return new IsAfter(this, PackedLocalDate.pack(date));
    }

    public IsSunday isSunday() {
        return new IsSunday(this);
    }

    public IsMonday isMonday() {
        return new IsMonday(this);
    }

    public IsTuesday isTuesday() {
        return new IsTuesday(this);
    }

    public IsWednesday isWednesday() {
        return new IsWednesday(this);
    }

    public IsThursday isThursday() {
        return new IsThursday(this);
    }

    public IsFriday isFriday() {
        return new IsFriday(this);
    }

    public IsSaturday isSaturday() {
        return new IsSaturday(this);
    }

    public IsInJanuary isInJanuary() {
        return new IsInJanuary(this);
    }

    public IsInFebruary isInFebruary() {
        return new IsInFebruary(this);
    }

    public IsInMarch isInMarch() {
        return new IsInMarch(this);
    }

    public IsInApril isInApril() {
        return new IsInApril(this);
    }

    public IsInMay isInMay() {
        return new IsInMay(this);
    }

    public IsInJune isInJune() {
        return new IsInJune(this);
    }

    public Filter isInJuly() {
        return new IsInJuly(this);
    }

    public Filter isInAugust() {
        return new IsInAugust(this);
    }

    public Filter isInSeptember() {
        return new IsInSeptember(this);
    }

    public Filter isInOctober() {
        return new IsInOctober(this);
    }

    public Filter isInNovember() {
        return new IsInNovember(this);
    }

    public Filter isInDecember() {
        return new IsInDecember(this);
    }

    public IsInQ1 isInQ1() {
        return new IsInQ1(this);
    }

    public IsInQ2 isInQ2() {
        return new IsInQ2(this);
    }

    public IsInQ3 isInQ3() {
        return new IsInQ3(this);
    }

    public IsInQ4 isInQ4() {
        return new IsInQ4(this);
    }

    public IsFirstDayOfTheMonth isFirstDayOfMonth() {
        return new IsFirstDayOfTheMonth(this);
    }

    public IsLastDayOfTheMonth isLastDayOfMonth() {
        return new IsLastDayOfTheMonth(this);
    }

    public IsInYear isInYear(int year) {
        return new IsInYear(this, year);
    }
}

