/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterable;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.text.NumberFormat;
import java.time.ZoneOffset;
import java.util.function.DoublePredicate;
import org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.NumberFillers;
import tech.tablesaw.columns.numbers.NumberFilters;
import tech.tablesaw.columns.numbers.NumberMapFunctions;
import tech.tablesaw.columns.numbers.Stats;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.filtering.predicates.DoubleBiPredicate;
import tech.tablesaw.filtering.predicates.DoubleRangePredicate;
import tech.tablesaw.selection.Selection;

public interface NumberColumn
extends Column,
DoubleIterable,
NumberMapFunctions,
NumberFilters,
NumberFillers<NumberColumn>,
CategoricalColumn {
    public static final double MISSING_VALUE = (Double)ColumnType.NUMBER.getMissingValue();

    public static boolean valueIsMissing(double value) {
        return Double.isNaN(value);
    }

    @Override
    public boolean isMissing(int var1);

    public void setPrintFormatter(NumberFormat var1, String var2);

    public void setPrintFormatter(NumberColumnFormatter var1);

    @Override
    public int size();

    @Override
    public Table summary();

    public Stats stats();

    public DoubleArrayList top(int var1);

    public DoubleArrayList bottom(int var1);

    @Override
    public Column unique();

    public double firstElement();

    public NumberColumn append(float var1);

    public NumberColumn append(double var1);

    @Override
    public String getString(int var1);

    @Override
    public double getDouble(int var1);

    @Override
    public String getUnformattedString(int var1);

    @Override
    public NumberColumn emptyCopy();

    @Override
    public NumberColumn emptyCopy(int var1);

    @Override
    public NumberColumn lead(int var1);

    @Override
    public NumberColumn lag(int var1);

    @Override
    public NumberColumn copy();

    @Override
    public void clear();

    @Override
    public void sortAscending();

    @Override
    public void sortDescending();

    @Override
    public boolean isEmpty();

    @Override
    public NumberColumn appendCell(String var1);

    public Integer roundInt(int var1);

    public long getLong(int var1);

    @Override
    public IntComparator rowComparator();

    @Override
    public double get(int var1);

    public NumberColumn set(int var1, double var2);

    public NumberColumn set(Selection var1, double var2);

    @Override
    public double[] asDoubleArray();

    @Override
    public void append(Column var1);

    public DoubleIterator iterator();

    @Override
    public NumberColumn where(Filter var1);

    @Override
    public NumberColumn where(Selection var1);

    @Override
    public Selection eval(DoublePredicate var1);

    @Override
    public Selection eval(DoubleBiPredicate var1, NumberColumn var2);

    @Override
    public Selection eval(DoubleBiPredicate var1, Number var2);

    @Override
    public Selection eval(DoubleRangePredicate var1, Number var2, Number var3);

    @Override
    public Selection isIn(Number ... var1);

    @Override
    public Selection isNotIn(Number ... var1);

    public DoubleSet asSet();

    public boolean contains(double var1);

    @Override
    public int byteSize();

    @Override
    public byte[] asBytes(int var1);

    @Override
    public int[] asIntArray();

    @Override
    public DoubleList dataInternal();

    @Override
    public NumberColumn appendMissing();

    @Override
    default public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!NumberColumn.valueIsMissing(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    default public double sum() {
        return AggregateFunctions.sum.summarize(this);
    }

    default public double product() {
        return AggregateFunctions.product.summarize(this);
    }

    default public double mean() {
        return AggregateFunctions.mean.summarize(this);
    }

    default public double median() {
        return AggregateFunctions.median.summarize(this);
    }

    default public double quartile1() {
        return AggregateFunctions.quartile1.summarize(this);
    }

    default public double quartile3() {
        return AggregateFunctions.quartile3.summarize(this);
    }

    default public double percentile(double percentile) {
        return AggregateFunctions.percentile(this, percentile);
    }

    default public double range() {
        return AggregateFunctions.range.summarize(this);
    }

    default public double max() {
        return AggregateFunctions.max.summarize(this);
    }

    default public double min() {
        return AggregateFunctions.min.summarize(this);
    }

    default public double variance() {
        return AggregateFunctions.variance.summarize(this);
    }

    default public double populationVariance() {
        return AggregateFunctions.populationVariance.summarize(this);
    }

    default public double standardDeviation() {
        return AggregateFunctions.stdDev.summarize(this);
    }

    default public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.summarize(this);
    }

    default public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.summarize(this);
    }

    default public double geometricMean() {
        return AggregateFunctions.geometricMean.summarize(this);
    }

    default public double quadraticMean() {
        return AggregateFunctions.quadraticMean.summarize(this);
    }

    default public double kurtosis() {
        return AggregateFunctions.kurtosis.summarize(this);
    }

    default public double skewness() {
        return AggregateFunctions.skewness.summarize(this);
    }

    public DateTimeColumn asDateTimes(ZoneOffset var1);

    default public double pearsons(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new PearsonsCorrelation().correlation(x, y);
    }

    default public double spearmans(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new SpearmansCorrelation().correlation(x, y);
    }

    default public double kendalls(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new KendallsCorrelation().correlation(x, y);
    }

    @Override
    default public int countUnique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (NumberColumn.valueIsMissing(this.get(i))) continue;
            doubles.add(this.get(i));
        }
        return doubles.size();
    }
}

