/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;

public class Stats {
    long n;
    double sum;
    double mean;
    double min;
    double max;
    double variance;
    double standardDeviation;
    double geometricMean;
    double quadraticMean;
    double secondMoment;
    double populationVariance;
    double sumOfLogs;
    double sumOfSquares;
    private String name;

    public Stats(String name) {
        this.name = name;
    }

    public static Stats create(FloatColumn values) {
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        FloatIterator floatIterator = values.iterator();
        while (floatIterator.hasNext()) {
            float f = ((Float)floatIterator.next()).floatValue();
            summaryStatistics.addValue((double)f);
        }
        return Stats.getStats(values, summaryStatistics);
    }

    public static Stats create(DoubleColumn values) {
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        DoubleIterator doubleIterator = values.iterator();
        while (doubleIterator.hasNext()) {
            double f = (Double)doubleIterator.next();
            summaryStatistics.addValue(f);
        }
        return Stats.getStats(values, summaryStatistics);
    }

    public static Stats create(IntColumn ints) {
        FloatColumn values = new FloatColumn(ints.name(), ints.asFloatArray());
        return Stats.create(values);
    }

    public static Stats create(ShortColumn ints) {
        FloatColumn values = new FloatColumn(ints.name(), ints.asFloatArray());
        return Stats.create(values);
    }

    public static Stats create(LongColumn ints) {
        FloatColumn values = new FloatColumn(ints.name(), ints.asFloatArray());
        return Stats.create(values);
    }

    private static Stats getStats(FloatColumn values, SummaryStatistics summaryStatistics) {
        Stats stats = new Stats("Column: " + values.name());
        stats.min = (float)summaryStatistics.getMin();
        stats.max = (float)summaryStatistics.getMax();
        stats.n = summaryStatistics.getN();
        stats.sum = summaryStatistics.getSum();
        stats.variance = summaryStatistics.getVariance();
        stats.populationVariance = summaryStatistics.getPopulationVariance();
        stats.quadraticMean = summaryStatistics.getQuadraticMean();
        stats.geometricMean = summaryStatistics.getGeometricMean();
        stats.mean = summaryStatistics.getMean();
        stats.standardDeviation = summaryStatistics.getStandardDeviation();
        stats.sumOfLogs = summaryStatistics.getSumOfLogs();
        stats.sumOfSquares = summaryStatistics.getSumsq();
        stats.secondMoment = summaryStatistics.getSecondMoment();
        return stats;
    }

    private static Stats getStats(DoubleColumn values, SummaryStatistics summaryStatistics) {
        Stats stats = new Stats("Column: " + values.name());
        stats.min = summaryStatistics.getMin();
        stats.max = summaryStatistics.getMax();
        stats.n = summaryStatistics.getN();
        stats.sum = summaryStatistics.getSum();
        stats.variance = summaryStatistics.getVariance();
        stats.populationVariance = summaryStatistics.getPopulationVariance();
        stats.quadraticMean = summaryStatistics.getQuadraticMean();
        stats.geometricMean = summaryStatistics.getGeometricMean();
        stats.mean = summaryStatistics.getMean();
        stats.standardDeviation = summaryStatistics.getStandardDeviation();
        stats.sumOfLogs = summaryStatistics.getSumOfLogs();
        stats.sumOfSquares = summaryStatistics.getSumsq();
        stats.secondMoment = summaryStatistics.getSecondMoment();
        return stats;
    }

    public float range() {
        return (float)(this.max - this.min);
    }

    public float standardDeviation() {
        return (float)this.standardDeviation;
    }

    public long n() {
        return this.n;
    }

    public float mean() {
        return (float)(this.sum / (double)this.n);
    }

    public float min() {
        return (float)this.min;
    }

    public float max() {
        return (float)this.max;
    }

    public float sum() {
        return (float)this.sum;
    }

    public float variance() {
        return (float)this.variance;
    }

    public float sumOfSquares() {
        return (float)this.sumOfSquares;
    }

    public float populationVariance() {
        return (float)this.populationVariance;
    }

    public float sumOfLogs() {
        return (float)this.sumOfLogs;
    }

    public float geometricMean() {
        return (float)this.geometricMean;
    }

    public float quadraticMean() {
        return (float)this.quadraticMean;
    }

    public float secondMoment() {
        return (float)this.secondMoment;
    }

    public Table asTable() {
        Table t = Table.create(this.name);
        CategoryColumn measure = new CategoryColumn("Measure");
        FloatColumn value = new FloatColumn("Value");
        t.addColumn(measure);
        t.addColumn(value);
        measure.add("n");
        value.append(this.n);
        measure.add("sum");
        value.append(this.sum());
        measure.add("Mean");
        value.append(this.mean());
        measure.add("Min");
        value.append(this.min());
        measure.add("Max");
        value.append(this.max());
        measure.add("Range");
        value.append(this.range());
        measure.add("Variance");
        value.append(this.variance());
        measure.add("Std. Dev");
        value.append(this.standardDeviation());
        return t;
    }

    public Table asTableComplete() {
        Table t = this.asTable();
        CategoryColumn measure = t.categoryColumn("Measure");
        FloatColumn value = t.floatColumn("Value");
        measure.add("Sum of Squares");
        value.append(this.sumOfSquares());
        measure.add("Sum of Logs");
        value.append(this.sumOfLogs());
        measure.add("Population Variance");
        value.append(this.populationVariance());
        measure.add("Geometric Mean");
        value.append(this.geometricMean());
        measure.add("Quadratic Mean");
        value.append(this.quadraticMean());
        measure.add("Second Moment");
        value.append(this.secondMoment());
        return t;
    }
}

