/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.SubTable;

public class TableGroup
implements Iterable<SubTable> {
    private static final String SPLIT_STRING = "~~~";
    private final Table original;
    private final List<SubTable> subTables;
    private String[] splitColumnNames;

    public TableGroup(Table original, String ... splitColumnNames) {
        this.original = original.sortOn(splitColumnNames);
        this.subTables = this.splitOn(splitColumnNames);
        Preconditions.checkState((!this.subTables.isEmpty() ? 1 : 0) != 0);
        this.splitColumnNames = splitColumnNames;
    }

    public TableGroup(Table original, Column ... columns) {
        this.splitColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.splitColumnNames[i] = columns[i].name();
        }
        this.original = original.sortOn(this.splitColumnNames);
        this.subTables = this.splitOn(this.splitColumnNames);
        Preconditions.checkState((!this.subTables.isEmpty() ? 1 : 0) != 0);
    }

    private List<SubTable> splitOn(String ... columnNames) {
        int columnCount = columnNames.length;
        ArrayList<SubTable> tables = new ArrayList<SubTable>();
        int[] columnIndices = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnIndices[i] = this.original.columnIndex(columnNames[i]);
        }
        Table empty = this.original.emptyCopy();
        SubTable newView = new SubTable(empty);
        String lastKey = "";
        newView.setName(lastKey);
        for (int row = 0; row < this.original.rowCount(); ++row) {
            String newKey = "";
            ArrayList<String> values = new ArrayList<String>();
            for (int col = 0; col < columnCount; ++col) {
                if (col > 0) {
                    newKey = newKey + SPLIT_STRING;
                }
                String groupKey = this.original.get(row, columnIndices[col]);
                newKey = newKey + groupKey;
                values.add(groupKey);
            }
            if (!newKey.equals(lastKey)) {
                if (!newView.isEmpty()) {
                    tables.add(newView);
                }
                newView = new SubTable(empty);
                newView.setName(newKey);
                newView.setValues(values);
                lastKey = newKey;
            }
            newView.addRow(row, this.original);
        }
        if (!tables.contains(newView) && !newView.isEmpty()) {
            if (columnCount == 1) {
                tables.add(newView);
            } else {
                tables.add(newView);
            }
        }
        return tables;
    }

    public List<SubTable> getSubTables() {
        return this.subTables;
    }

    public int size() {
        return this.subTables.size();
    }

    public Table reduce(String numericColumnName, AggregateFunction function) {
        Preconditions.checkArgument((!this.subTables.isEmpty() ? 1 : 0) != 0);
        Table t = Table.create(this.original.name() + " summary");
        CategoryColumn groupColumn = new CategoryColumn("Group", this.subTables.size());
        FloatColumn resultColumn = new FloatColumn(function.functionName(), this.subTables.size());
        t.addColumn(groupColumn);
        t.addColumn(resultColumn);
        for (SubTable subTable : this.subTables) {
            double result = subTable.agg(numericColumnName, function);
            groupColumn.append(subTable.name().replace(SPLIT_STRING, " * "));
            resultColumn.append((float)result);
        }
        return t;
    }

    @Override
    public Iterator<SubTable> iterator() {
        return this.subTables.iterator();
    }
}

