/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.DateTimeColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalDateTime;

public interface DateTimeMapUtils
extends DateTimeColumnUtils {
    default public LongColumn differenceInMilliseconds(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.MILLIS);
    }

    default public LongColumn differenceInSeconds(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.SECONDS);
    }

    default public LongColumn differenceInMinutes(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.MINUTES);
    }

    default public LongColumn differenceInHours(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.HOURS);
    }

    default public LongColumn differenceInDays(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.DAYS);
    }

    default public LongColumn differenceInYears(DateTimeColumn column2) {
        return this.difference(column2, ChronoUnit.YEARS);
    }

    default public LongColumn difference(DateTimeColumn column2, ChronoUnit unit) {
        LongColumn newColumn = new LongColumn(this.name() + " - " + column2.name());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            long c2 = column2.getLongInternal(r);
            if (c1 == Long.MIN_VALUE || c2 == Long.MIN_VALUE) {
                newColumn.append(LongColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(this.difference(c1, c2, unit));
        }
        return newColumn;
    }

    default public long difference(long packedLocalDateTime1, long packedLocalDateTime2, ChronoUnit unit) {
        LocalDateTime value1 = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime1);
        LocalDateTime value2 = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime2);
        return unit.between(value1, value2);
    }

    default public ShortColumn hour() {
        ShortColumn newColumn = new ShortColumn(this.name() + "[hour]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != Long.MIN_VALUE) {
                newColumn.append(PackedLocalDateTime.getHour(c1));
                continue;
            }
            newColumn.append(ShortColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public ShortColumn minuteOfDay() {
        ShortColumn newColumn = new ShortColumn(this.name() + "[minute-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != Long.MIN_VALUE) {
                newColumn.append((short)PackedLocalDateTime.getMinuteOfDay(c1));
                continue;
            }
            newColumn.append(ShortColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public IntColumn secondOfDay() {
        IntColumn newColumn = new IntColumn(this.name() + "[second-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (c1 != Long.MIN_VALUE) {
                newColumn.append(PackedLocalDateTime.getSecondOfDay(c1));
                continue;
            }
            newColumn.append(IntColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    public LocalDateTime get(int var1);

    public long getLongInternal(int var1);
}

