/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering.columnbased;

import com.google.common.base.Preconditions;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class ColumnEqualTo
extends ColumnFilter {
    private final ColumnReference otherColumn;

    public ColumnEqualTo(ColumnReference a, ColumnReference b) {
        super(a);
        this.otherColumn = b;
    }

    private static Selection apply(IntColumn column1, IntColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(ShortColumn column1, ShortColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(LongColumn column1, LongColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(CategoryColumn column1, CategoryColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(BooleanColumn column1, BooleanColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(DateColumn column1, DateColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(DateTimeColumn column1, DateTimeColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(TimeColumn column1, TimeColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(FloatColumn column1, FloatColumn column2) {
        return column1.isEqualTo(column2);
    }

    private static Selection apply(DoubleColumn column1, DoubleColumn column2) {
        return column1.isEqualTo(column2);
    }

    @Override
    public Selection apply(Table relation) {
        Column column = relation.column(this.columnReference().getColumnName());
        Column other = relation.column(this.otherColumn.getColumnName());
        Preconditions.checkArgument((column.type() == other.type() ? 1 : 0) != 0);
        if (column.type() == ColumnType.INTEGER) {
            return ColumnEqualTo.apply((IntColumn)column, (IntColumn)other);
        }
        if (column.type() == ColumnType.LONG_INT) {
            return ColumnEqualTo.apply((LongColumn)column, (LongColumn)other);
        }
        if (column.type() == ColumnType.SHORT_INT) {
            return ColumnEqualTo.apply((ShortColumn)column, (ShortColumn)other);
        }
        if (column.type() == ColumnType.CATEGORY) {
            return ColumnEqualTo.apply((CategoryColumn)column, (CategoryColumn)other);
        }
        if (column.type() == ColumnType.BOOLEAN) {
            return ColumnEqualTo.apply((BooleanColumn)column, (BooleanColumn)other);
        }
        if (column.type() == ColumnType.LOCAL_DATE) {
            return ColumnEqualTo.apply((DateColumn)column, (DateColumn)other);
        }
        if (column.type() == ColumnType.LOCAL_DATE_TIME) {
            return ColumnEqualTo.apply((DateTimeColumn)column, (DateTimeColumn)other);
        }
        if (column.type() == ColumnType.LOCAL_TIME) {
            return ColumnEqualTo.apply((TimeColumn)column, (TimeColumn)other);
        }
        if (column.type() == ColumnType.FLOAT) {
            return ColumnEqualTo.apply((FloatColumn)column, (FloatColumn)other);
        }
        if (column.type() == ColumnType.DOUBLE) {
            return ColumnEqualTo.apply((DoubleColumn)column, (DoubleColumn)other);
        }
        throw new UnsupportedOperationException("Not yet implemented for this column type");
    }
}

