/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.packeddata;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.LocalTime;

public class PackedLocalTime {
    public static final int MIDNIGHT = PackedLocalTime.pack(LocalTime.MIDNIGHT);
    public static final int NOON = PackedLocalTime.pack(LocalTime.NOON);

    public static byte getHour(int time) {
        return (byte)(time >> 24);
    }

    public static char getMillisecondOfMinute(int time) {
        byte byte1 = (byte)(time >> 8);
        byte byte2 = (byte)time;
        return (char)(byte1 << 8 | byte2 & 0xFF);
    }

    public static int getNano(int time) {
        long millis = PackedLocalTime.getMillisecondOfMinute(time);
        millis *= 1000000L;
        byte seconds = PackedLocalTime.getSecond(time);
        long nanos = (long)seconds * 1000000000L;
        return (int)(millis -= nanos);
    }

    public static int getMilliseconds(int time) {
        long millis = PackedLocalTime.getMillisecondOfMinute(time);
        millis *= 1000000L;
        byte seconds = PackedLocalTime.getSecond(time);
        long nanos = (long)seconds * 1000000000L;
        return (int)((millis -= nanos) / 1000000L);
    }

    public static long toNanoOfDay(int time) {
        long nano = (long)PackedLocalTime.getHour(time) * 3600000000000L;
        nano += (long)PackedLocalTime.getMinute(time) * 60000000000L;
        nano += (long)PackedLocalTime.getSecond(time) * 1000000000L;
        return nano += (long)PackedLocalTime.getNano(time);
    }

    public static LocalTime asLocalTime(int time) {
        if (time == -1) {
            return null;
        }
        byte hourByte = (byte)(time >> 24);
        byte minuteByte = (byte)(time >> 16);
        byte millisecondByte1 = (byte)(time >> 8);
        byte millisecondByte2 = (byte)time;
        char millis = (char)(millisecondByte1 << 8 | millisecondByte2 & 0xFF);
        int second = millis / 1000;
        int nanoOfSecond = millis % 1000 * 1000000;
        return LocalTime.of(hourByte, minuteByte, second, nanoOfSecond);
    }

    public static byte getMinute(int time) {
        return (byte)(time >> 16);
    }

    public static int pack(LocalTime time) {
        byte hour = (byte)time.getHour();
        byte minute = (byte)time.getMinute();
        char millis = (char)((double)time.getNano() / 1000000.0);
        millis = (char)(millis + (char)(time.getSecond() * 1000));
        byte m1 = (byte)(millis >> 8);
        byte m2 = (byte)millis;
        return Ints.fromBytes((byte)hour, (byte)minute, (byte)m1, (byte)m2);
    }

    public static byte getSecond(int packedLocalTime) {
        return (byte)(PackedLocalTime.getMillisecondOfMinute(packedLocalTime) / 1000);
    }

    public static int getMinuteOfDay(int packedLocalTime) {
        return PackedLocalTime.getHour(packedLocalTime) * 60 + PackedLocalTime.getMinute(packedLocalTime);
    }

    public static int getSecondOfDay(int packedLocalTime) {
        int total = PackedLocalTime.getHour(packedLocalTime) * 60 * 60;
        total += PackedLocalTime.getMinute(packedLocalTime) * 60;
        return total += PackedLocalTime.getSecond(packedLocalTime);
    }

    public static int getMillisecondOfDay(int packedLocalTime) {
        return (int)(PackedLocalTime.toNanoOfDay(packedLocalTime) / 1000000L);
    }

    public static String toShortTimeString(int time) {
        if (time == -1) {
            return "";
        }
        byte hourByte = (byte)(time >> 24);
        byte minuteByte = (byte)(time >> 16);
        byte millisecondByte1 = (byte)(time >> 8);
        byte millisecondByte2 = (byte)time;
        char millis = (char)(millisecondByte1 << 8 | millisecondByte2 & 0xFF);
        int second = millis / 1000;
        return String.format("%s:%s:%s", Strings.padStart((String)Byte.toString(hourByte), (int)2, (char)'0'), Strings.padStart((String)Byte.toString(minuteByte), (int)2, (char)'0'), Strings.padStart((String)Integer.toString(second), (int)2, (char)'0'));
    }

    public static boolean isMidnight(int packedTime) {
        return packedTime == MIDNIGHT;
    }

    public static boolean isNoon(int packedTime) {
        return packedTime == NOON;
    }

    public static boolean isAfter(int packedTime, int value) {
        return packedTime > value;
    }

    public static boolean isOnOrAfter(int packedTime, int value) {
        return packedTime >= value;
    }

    public static boolean isBefore(int packedTime, int value) {
        return packedTime < value;
    }

    public static boolean isOnOrBefore(int packedTime, int value) {
        return packedTime <= value;
    }

    public static boolean isEqualTo(int packedTime, int value) {
        return packedTime == value;
    }

    public static boolean AM(int packedTime) {
        return packedTime < NOON;
    }

    public static boolean PM(int packedTime) {
        return packedTime >= NOON;
    }
}

