/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.table.RollingColumn;
import tech.tablesaw.util.Selection;

public interface Column {
    public int size();

    public Table summary();

    default public Column subset(Selection rows) {
        Column c = this.emptyCopy();
        IntIterator intIterator = rows.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            c.appendCell(this.getString(row));
        }
        return c;
    }

    public int countMissing();

    public int countUnique();

    public Column unique();

    public String name();

    public Column setName(String var1);

    public ColumnType type();

    public String getString(int var1);

    public Column emptyCopy();

    public Column copy();

    public Column emptyCopy(int var1);

    public void clear();

    public void sortAscending();

    public void sortDescending();

    public boolean isEmpty();

    public void appendCell(String var1);

    public String id();

    public String metadata();

    public ColumnMetadata columnMetadata();

    public IntComparator rowComparator();

    default public String first() {
        return this.getString(0);
    }

    default public String last() {
        return this.getString(this.size() - 1);
    }

    public void append(Column var1);

    default public Column first(int numRows) {
        Column col = this.emptyCopy();
        int rows = Math.min(numRows, this.size());
        for (int i = 0; i < rows; ++i) {
            col.appendCell(this.getString(i));
        }
        return col;
    }

    default public Column last(int numRows) {
        Column col = this.emptyCopy();
        int rows = Math.min(numRows, this.size());
        for (int i = this.size() - rows; i < this.size(); ++i) {
            col.appendCell(this.getString(i));
        }
        return col;
    }

    public String print();

    default public String title() {
        return "Column: " + this.name() + '\n';
    }

    public String comment();

    public void setComment(String var1);

    default public double[] asDoubleArray() {
        throw new UnsupportedOperationException("Method toDoubleArray() is not supported on non-numeric columns");
    }

    public int columnWidth();

    public Selection isMissing();

    public Selection isNotMissing();

    public int byteSize();

    public byte[] asBytes(int var1);

    public Column difference();

    default public RollingColumn rolling(int windowSize) {
        return new RollingColumn(this, windowSize);
    }
}

