/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.columns.Column;

public interface NumericColumn
extends Column {
    public static NumericColumn subtractColumns(NumericColumn column1, NumericColumn column2) {
        int col2Size;
        int col1Size = column1.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        if (column1 instanceof DoubleColumn || column2 instanceof DoubleColumn) {
            DoubleColumn result = new DoubleColumn(column1.name() + " - " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(DoubleColumn.subtract(column1.getDouble(r), column2.getDouble(r)));
            }
            return result;
        }
        if (column1 instanceof FloatColumn || column2 instanceof FloatColumn) {
            FloatColumn result = new FloatColumn(column1.name() + " - " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(FloatColumn.subtract(column1.getFloat(r), column2.getFloat(r)));
            }
            return result;
        }
        if (column1 instanceof LongColumn || column2 instanceof LongColumn) {
            LongColumn result = new LongColumn(column1.name() + " - " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(LongColumn.subtract(column1.getLong(r), column2.getLong(r)));
            }
            return result;
        }
        IntColumn result = new IntColumn(column1.name() + " - " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(IntColumn.subtract(column1.getInt(r), column2.getInt(r)));
        }
        return result;
    }

    public static NumericColumn addColumns(NumericColumn column1, NumericColumn column2) {
        int col2Size;
        int col1Size = column1.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        if (column1 instanceof DoubleColumn || column2 instanceof DoubleColumn) {
            DoubleColumn result = new DoubleColumn(column1.name() + " + " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(DoubleColumn.add(column1.getDouble(r), column2.getDouble(r)));
            }
            return result;
        }
        if (column1 instanceof FloatColumn || column2 instanceof FloatColumn) {
            FloatColumn result = new FloatColumn(column1.name() + " + " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(FloatColumn.add(column1.getFloat(r), column2.getFloat(r)));
            }
            return result;
        }
        if (column1 instanceof LongColumn || column2 instanceof LongColumn) {
            LongColumn result = new LongColumn(column1.name() + " + " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(LongColumn.add(column1.getLong(r), column2.getLong(r)));
            }
            return result;
        }
        IntColumn result = new IntColumn(column1.name() + " + " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(IntColumn.add(column1.getInt(r), column2.getInt(r)));
        }
        return result;
    }

    public static NumericColumn multiplyColumns(NumericColumn column1, NumericColumn column2) {
        int col2Size;
        int col1Size = column1.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        if (column1 instanceof DoubleColumn || column2 instanceof DoubleColumn) {
            DoubleColumn result = new DoubleColumn(column1.name() + " * " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(DoubleColumn.multiply(column1.getDouble(r), column2.getDouble(r)));
            }
            return result;
        }
        if (column1 instanceof FloatColumn || column2 instanceof FloatColumn) {
            FloatColumn result = new FloatColumn(column1.name() + " * " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(FloatColumn.multiply(column1.getFloat(r), column2.getFloat(r)));
            }
            return result;
        }
        if (column1 instanceof LongColumn || column2 instanceof LongColumn) {
            LongColumn result = new LongColumn(column1.name() + " * " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(LongColumn.multiply(column1.getLong(r), column2.getLong(r)));
            }
            return result;
        }
        IntColumn result = new IntColumn(column1.name() + " * " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(IntColumn.multiply(column1.getInt(r), column2.getInt(r)));
        }
        return result;
    }

    public static NumericColumn divideColumns(NumericColumn column1, NumericColumn column2) {
        int col2Size;
        int col1Size = column1.size();
        if (col1Size != (col2Size = column2.size())) {
            throw new IllegalArgumentException("The columns must have the same number of elements");
        }
        if (column1 instanceof DoubleColumn || column2 instanceof DoubleColumn) {
            DoubleColumn result = new DoubleColumn(column1.name() + " / " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(DoubleColumn.divide(column1.getDouble(r), column2.getDouble(r)));
            }
            return result;
        }
        if (column1 instanceof FloatColumn || column2 instanceof FloatColumn) {
            FloatColumn result = new FloatColumn(column1.name() + " / " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(FloatColumn.divide(column1.getFloat(r), column2.getFloat(r)));
            }
            return result;
        }
        if (column1 instanceof LongColumn || column2 instanceof LongColumn) {
            LongColumn result = new LongColumn(column1.name() + " / " + column2.name(), col1Size);
            for (int r = 0; r < col1Size; ++r) {
                result.append(LongColumn.divide(column1.getLong(r), column2.getLong(r)));
            }
            return result;
        }
        IntColumn result = new IntColumn(column1.name() + " / " + column2.name(), col1Size);
        for (int r = 0; r < col1Size; ++r) {
            result.append(IntColumn.divide(column1.getInt(r), column2.getInt(r)));
        }
        return result;
    }

    default public NumericColumn subtract(NumericColumn column2) {
        return NumericColumn.subtractColumns(this, column2);
    }

    default public NumericColumn add(NumericColumn column2) {
        return NumericColumn.addColumns(this, column2);
    }

    default public NumericColumn multiply(NumericColumn column2) {
        return NumericColumn.multiplyColumns(this, column2);
    }

    default public NumericColumn divide(NumericColumn column2) {
        return NumericColumn.divideColumns(this, column2);
    }

    default public NumericColumn add(Number value) {
        if (value instanceof Double || this instanceof DoubleColumn) {
            double val = (Double)value;
            DoubleColumn result = new DoubleColumn(this.name() + " + " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(DoubleColumn.add(this.getDouble(i), val));
            }
            return result;
        }
        if (value instanceof Float || this instanceof FloatColumn) {
            float val = ((Float)value).floatValue();
            FloatColumn result = new FloatColumn(this.name() + " + " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(FloatColumn.add(val, this.getFloat(i)));
            }
            return result;
        }
        if (value instanceof Long || this instanceof LongColumn) {
            long val = (Long)value;
            LongColumn result = new LongColumn(this.name() + " + " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(LongColumn.add(this.getLong(i), val));
            }
            return result;
        }
        int val = (Integer)value;
        IntColumn result = new IntColumn(this.name() + " + " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(IntColumn.add(this.getInt(i), val));
        }
        return result;
    }

    default public NumericColumn subtract(Number value) {
        if (value instanceof Double || this instanceof DoubleColumn) {
            double val = (Double)value;
            DoubleColumn result = new DoubleColumn(this.name() + " - " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(DoubleColumn.subtract(this.getDouble(i), val));
            }
            return result;
        }
        if (value instanceof Float || this instanceof FloatColumn) {
            float val = ((Float)value).floatValue();
            FloatColumn result = new FloatColumn(this.name() + " - " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(FloatColumn.subtract(val, this.getFloat(i)));
            }
            return result;
        }
        if (value instanceof Long || this instanceof LongColumn) {
            long val = (Long)value;
            LongColumn result = new LongColumn(this.name() + " - " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(LongColumn.subtract(this.getLong(i), val));
            }
            return result;
        }
        int val = (Integer)value;
        IntColumn result = new IntColumn(this.name() + " - " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(IntColumn.subtract(this.getInt(i), val));
        }
        return result;
    }

    default public NumericColumn divide(Number value) {
        if (value instanceof Double || this instanceof DoubleColumn) {
            double val = (Double)value;
            DoubleColumn result = new DoubleColumn(this.name() + " / " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(DoubleColumn.divide(this.getDouble(i), val));
            }
            return result;
        }
        if (value instanceof Float || this instanceof FloatColumn) {
            float val = ((Float)value).floatValue();
            FloatColumn result = new FloatColumn(this.name() + " / " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(FloatColumn.divide(val, this.getFloat(i)));
            }
            return result;
        }
        if (value instanceof Long || this instanceof LongColumn) {
            long val = (Long)value;
            LongColumn result = new LongColumn(this.name() + " / " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(LongColumn.divide(this.getLong(i), val));
            }
            return result;
        }
        int val = (Integer)value;
        IntColumn result = new IntColumn(this.name() + " / " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(IntColumn.divide(this.getInt(i), val));
        }
        return result;
    }

    default public NumericColumn multiply(Number value) {
        if (value instanceof Double || this instanceof DoubleColumn) {
            double val = (Double)value;
            DoubleColumn result = new DoubleColumn(this.name() + " * " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(DoubleColumn.multiply(this.getDouble(i), val));
            }
            return result;
        }
        if (value instanceof Float || this instanceof FloatColumn) {
            float val = ((Float)value).floatValue();
            FloatColumn result = new FloatColumn(this.name() + " * " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(FloatColumn.multiply(val, this.getFloat(i)));
            }
            return result;
        }
        if (value instanceof Long || this instanceof LongColumn) {
            long val = (Long)value;
            LongColumn result = new LongColumn(this.name() + " * " + val);
            for (int i = 0; i < this.size(); ++i) {
                result.append(LongColumn.multiply(this.getLong(i), val));
            }
            return result;
        }
        int val = (Integer)value;
        IntColumn result = new IntColumn(this.name() + " * " + val);
        for (int i = 0; i < this.size(); ++i) {
            result.append(IntColumn.multiply(this.getInt(i), val));
        }
        return result;
    }

    @Override
    public double[] asDoubleArray();

    default public int getInt(int index) {
        throw new UnsupportedOperationException("getInt() method not supported for all data types");
    }

    default public long getLong(int index) {
        throw new UnsupportedOperationException("getLong() method not supported for all data types");
    }

    default public float getFloat(int index) {
        throw new UnsupportedOperationException("getFloat() method not supported for all data types");
    }

    default public double getDouble(int index) {
        throw new UnsupportedOperationException("getDouble() method not supported for all data types");
    }

    public double max();

    public double min();

    public double product();

    public double mean();

    public double median();

    public double quartile1();

    public double quartile3();

    public double percentile(double var1);

    public double range();

    public double variance();

    public double populationVariance();

    public double standardDeviation();

    public double sumOfLogs();

    public double sumOfSquares();

    public double geometricMean();

    public double quadraticMean();

    public double kurtosis();

    public double skewness();
}

