/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntConvertibleColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.IntBiPredicate;
import tech.tablesaw.filtering.IntPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.IntMapUtils;
import tech.tablesaw.sorting.IntComparisonUtil;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseIntComparator;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class IntColumn
extends AbstractColumn
implements IntMapUtils,
NumericColumn,
IntConvertibleColumn {
    public static final int MISSING_VALUE = (Integer)ColumnType.INTEGER.getMissingValue();
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 4;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private IntArrayList data;
    final IntComparator comparator = new IntComparator(){

        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        public int compare(int i1, int i2) {
            int prim1 = IntColumn.this.get(i1);
            int prim2 = IntColumn.this.get(i2);
            return IntComparisonUtil.getInstance().compare(prim1, prim2);
        }
    };

    public IntColumn(String name) {
        this(name, new IntArrayList(128));
    }

    public IntColumn(String name, int initialSize) {
        this(name, new IntArrayList(initialSize));
    }

    public IntColumn(String name, IntArrayList data) {
        super(name);
        this.data = data;
    }

    public IntColumn(String name, int[] arr) {
        this(name, new IntArrayList(arr));
    }

    public IntColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new IntArrayList(metadata.getSize());
    }

    protected static boolean isMissing(int value) {
        return value == MISSING_VALUE;
    }

    private static int convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Integer.parseInt(matcher.replaceAll(""));
    }

    public IntArrayList data() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public ColumnType type() {
        return ColumnType.INTEGER;
    }

    public void append(int i) {
        this.data.add(i);
    }

    public void set(int index, int value) {
        this.data.set(index, value);
    }

    public void set(int newValue, Selection rowSelection) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
    }

    public Selection isLessThan(int i) {
        return this.select(isLessThan, i);
    }

    public Selection isGreaterThan(int i) {
        return this.select(isGreaterThan, i);
    }

    public Selection isGreaterThanOrEqualTo(int i) {
        return this.select(isGreaterThanOrEqualTo, i);
    }

    public Selection isLessThanOrEqualTo(int i) {
        return this.select(isLessThanOrEqualTo, i);
    }

    public Selection isNotEqualTo(int i) {
        return this.select(isNotEqualTo, i);
    }

    public Selection isEqualTo(int i) {
        return this.select(isEqualTo, i);
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    public Selection isIn(int ... values) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        block0: for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            for (int v : values) {
                if (v != next) continue;
                bitmap.add(idx);
                continue block0;
            }
        }
        return bitmap;
    }

    public Selection isEqualTo(IntColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator otherIterator = other.iterator();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int otherNext;
            int next = (Integer)intListIterator.next();
            if (next == (otherNext = otherIterator.nextInt())) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isGreaterThan(IntColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator otherIterator = other.iterator();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int otherNext;
            int next = (Integer)intListIterator.next();
            if (next > (otherNext = otherIterator.nextInt())) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isLessThan(IntColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator otherIterator = other.iterator();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int otherNext;
            int next = (Integer)intListIterator.next();
            if (next < (otherNext = otherIterator.nextInt())) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Table summary() {
        return Stats.create(this).asTable();
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        this.data.forEach(i -> selection.add(i));
        return selection.size();
    }

    @Override
    public IntColumn unique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        this.data.forEach(i -> selection.add(i));
        return new IntColumn(this.name() + " Unique values", IntArrayList.wrap((int[])selection.toArray()));
    }

    public IntSet asSet() {
        return new IntOpenHashSet((IntCollection)this.data);
    }

    @Override
    public String getString(int row) {
        int value = this.data.getInt(row);
        if (value == MISSING_VALUE) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public IntColumn emptyCopy() {
        IntColumn column = new IntColumn(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public IntColumn emptyCopy(int rowSize) {
        IntColumn column = new IntColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)ReverseIntComparator.instance());
    }

    @Override
    public IntColumn copy() {
        IntColumn column = new IntColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void appendCell(String object) {
        this.append(IntColumn.convert(object));
    }

    @Override
    public int get(int index) {
        return this.data.getInt(index);
    }

    @Override
    public int getInt(int index) {
        return this.data.getInt(index);
    }

    @Override
    public long getLong(int index) {
        int value = this.data.getInt(index);
        return value == MISSING_VALUE ? LongColumn.MISSING_VALUE : (long)value;
    }

    @Override
    public float getFloat(int index) {
        int value = this.data.getInt(index);
        return value == MISSING_VALUE ? FloatColumn.MISSING_VALUE : (float)value;
    }

    @Override
    public double getDouble(int index) {
        int value = this.data.getInt(index);
        return value == MISSING_VALUE ? DoubleColumn.MISSING_VALUE : (double)value;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public int firstElement() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return MISSING_VALUE;
    }

    @Override
    public long sum() {
        return Math.round(AggregateFunctions.sum.agg(this.asDoubleArray()));
    }

    @Override
    public double product() {
        return AggregateFunctions.product.agg(this);
    }

    @Override
    public double mean() {
        return AggregateFunctions.mean.agg(this);
    }

    @Override
    public double median() {
        return AggregateFunctions.median.agg(this);
    }

    @Override
    public double quartile1() {
        return AggregateFunctions.quartile1.agg(this);
    }

    @Override
    public double quartile3() {
        return AggregateFunctions.quartile3.agg(this);
    }

    @Override
    public double percentile(double percentile) {
        return AggregateFunctions.percentile(this.asDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return AggregateFunctions.range.agg(this);
    }

    @Override
    public double max() {
        return (int)Math.round(AggregateFunctions.max.agg(this));
    }

    @Override
    public double min() {
        return (int)Math.round(AggregateFunctions.min.agg(this));
    }

    @Override
    public double variance() {
        return AggregateFunctions.variance.agg(this);
    }

    @Override
    public double populationVariance() {
        return AggregateFunctions.populationVariance.agg(this);
    }

    @Override
    public double standardDeviation() {
        return AggregateFunctions.stdDev.agg(this);
    }

    @Override
    public double sumOfLogs() {
        return AggregateFunctions.sumOfLogs.agg(this);
    }

    @Override
    public double sumOfSquares() {
        return AggregateFunctions.sumOfSquares.agg(this);
    }

    @Override
    public double geometricMean() {
        return AggregateFunctions.geometricMean.agg(this);
    }

    @Override
    public double quadraticMean() {
        return AggregateFunctions.quadraticMean.agg(this);
    }

    @Override
    public double kurtosis() {
        return AggregateFunctions.kurtosis.agg(this);
    }

    @Override
    public double skewness() {
        return AggregateFunctions.skewness.agg(this);
    }

    public Selection isPositive() {
        return this.select(isPositive);
    }

    public Selection isNegative() {
        return this.select(isNegative);
    }

    public Selection isNonNegative() {
        return this.select(isNonNegative);
    }

    public Selection isZero() {
        return this.select(isZero);
    }

    public Selection isEven() {
        return this.select(isEven);
    }

    public Selection isOdd() {
        return this.select(isOdd);
    }

    public FloatArrayList asFloatArray() {
        FloatArrayList output = new FloatArrayList(this.data.size());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            output.add((float)aData);
        }
        return output;
    }

    @Override
    public int[] asIntArray() {
        int[] output = new int[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getInt(i);
        }
        return output;
    }

    @Override
    public double[] asDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            long val = this.data.getInt(i);
            output[i] = val == (long)MISSING_VALUE ? Double.NaN : (double)val;
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Int column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        IntColumn intColumn = (IntColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.append(intColumn.get(i));
        }
    }

    public IntColumn selectIf(IntPredicate predicate) {
        IntColumn column = this.emptyCopy();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    public IntColumn select(Selection selection) {
        IntColumn column = this.emptyCopy();
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            Integer next = (Integer)intIterator.next();
            column.append(this.data.getInt(next.intValue()));
        }
        return column;
    }

    public Selection select(IntPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(IntBiPredicate predicate, int value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public long sumIf(IntPredicate predicate) {
        long sum = 0L;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            sum += (long)next;
        }
        return sum;
    }

    public long countIf(IntPredicate predicate) {
        long count = 0L;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            ++count;
        }
        return count;
    }

    public IntColumn remainder(IntColumn column2) {
        IntColumn result = new IntColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public IntArrayList top(int n) {
        IntArrayList top = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)ReverseIntComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public IntArrayList bottom(int n) {
        IntArrayList bottom = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    public IntIterator iterator() {
        return this.data.iterator();
    }

    public Stats stats() {
        FloatColumn values = new FloatColumn(this.name(), this.asFloatArray());
        return Stats.create(values);
    }

    public boolean contains(int i) {
        return this.data.contains(i);
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.get(rowNumber)).array();
    }

    @Override
    public IntColumn difference() {
        IntColumn returnValue = new IntColumn(this.name(), this.size());
        if (this.data.isEmpty()) {
            return returnValue;
        }
        returnValue.append(MISSING_VALUE);
        for (int current = 1; current < this.data.size(); ++current) {
            returnValue.append(IntColumn.subtract(this.get(current), this.get(current - 1)));
        }
        return returnValue;
    }

    static int add(int val1, int val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 + val2;
    }

    static int multiply(int val1, int val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 * val2;
    }

    static int divide(int val1, int val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 / val2;
    }

    static int subtract(int val1, int val2) {
        if (val1 == MISSING_VALUE || val2 == MISSING_VALUE) {
            return MISSING_VALUE;
        }
        return val1 - val2;
    }

    public IntColumn cumSum() {
        int total = 0;
        IntColumn newColumn = new IntColumn(this.name() + "[cumSum]", this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            if (IntColumn.isMissing(value)) {
                newColumn.append(MISSING_VALUE);
                continue;
            }
            newColumn.append(total += value);
        }
        return newColumn;
    }

    public IntColumn cumProd() {
        int total = 1;
        IntColumn newColumn = new IntColumn(this.name() + "[cumProd]", this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int value = (Integer)intIterator.next();
            if (IntColumn.isMissing(value)) {
                newColumn.append(MISSING_VALUE);
                continue;
            }
            newColumn.append(total *= value);
        }
        return newColumn;
    }

    public DoubleColumn pctChange() {
        DoubleColumn newColumn = new DoubleColumn(this.name() + "[pctChange]", this.size());
        newColumn.append(DoubleColumn.MISSING_VALUE);
        for (int i = 1; i < this.size(); ++i) {
            newColumn.append((double)this.get(i) / (double)this.get(i - 1) - 1.0);
        }
        return newColumn;
    }
}

