/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import it.unimi.dsi.fastutil.shorts.ShortIterator;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.ShortColumnUtils;

public interface ShortMapUtils
extends ShortColumnUtils {
    default public IntColumn plus(ShortColumn ... columns) {
        String nString = this.names(columns);
        String name = String.format("sum(%s)", nString);
        IntColumn newColumn = new IntColumn(name);
        for (int r = 0; r < columns[0].size(); ++r) {
            int result = 0;
            for (ShortColumn column : columns) {
                result += column.get(r);
            }
            newColumn.append(result);
        }
        return newColumn;
    }

    default public String names(ShortColumn[] columns) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        for (ShortColumn column : columns) {
            builder.append(column.name());
            if (count < columns.length - 1) {
                builder.append(", ");
            }
            ++count;
        }
        return builder.toString();
    }

    default public FloatColumn asRatio() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            short next = (Short)shortIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    default public FloatColumn asPercent() {
        FloatColumn pctColumn = new FloatColumn(this.name() + " percents");
        float total = this.sum();
        ShortIterator shortIterator = this.iterator();
        while (shortIterator.hasNext()) {
            short next = (Short)shortIterator.next();
            if (total != 0.0f) {
                pctColumn.append((float)next / total * 100.0f);
                continue;
            }
            pctColumn.append(FloatColumn.MISSING_VALUE);
        }
        return pctColumn;
    }

    public long sum();
}

