/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import it.unimi.dsi.fastutil.shorts.ShortIterable;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.ShortBiPredicate;
import tech.tablesaw.filtering.ShortPredicate;

public interface ShortColumnUtils
extends Column,
ShortIterable {
    public static final ShortPredicate isZero = i -> i == 0;
    public static final ShortPredicate isNegative = i -> i < 0;
    public static final ShortPredicate isPositive = i -> i > 0;
    public static final ShortPredicate isNonNegative = i -> i >= 0;
    public static final ShortPredicate isEven = i -> (i & 1) == 0;
    public static final ShortPredicate isOdd = i -> (i & 1) != 0;
    public static final ShortBiPredicate isGreaterThan = new ShortBiPredicate(){

        @Override
        public boolean test(short valueToTest, int valueToCompareAgainst) {
            return valueToTest > valueToCompareAgainst;
        }
    };
    public static final ShortBiPredicate isGreaterThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest >= valueToCompareAgainst;
    public static final ShortBiPredicate isLessThan = (valueToTest, valueToCompareAgainst) -> valueToTest < valueToCompareAgainst;
    public static final ShortBiPredicate isLessThanOrEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest <= valueToCompareAgainst;
    public static final ShortBiPredicate isEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest == valueToCompareAgainst;
    public static final ShortBiPredicate isNotEqualTo = (valueToTest, valueToCompareAgainst) -> valueToTest != valueToCompareAgainst;
    public static final ShortPredicate isMissing = i -> i == ShortColumn.MISSING_VALUE;
    public static final ShortPredicate isNotMissing = i -> i != ShortColumn.MISSING_VALUE;
}

