/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class StringIsNotIn
extends ColumnFilter {
    private final CategoryColumn filterColumn;

    public StringIsNotIn(ColumnReference reference, CategoryColumn filterColumn) {
        super(reference);
        this.filterColumn = filterColumn;
    }

    public StringIsNotIn(ColumnReference reference, Collection<String> strings) {
        super(reference);
        this.filterColumn = new CategoryColumn("temp", Lists.newArrayList(strings));
    }

    public StringIsNotIn(ColumnReference reference, String ... strings) {
        super(reference);
        this.filterColumn = new CategoryColumn("temp", Lists.newArrayList((Object[])strings));
    }

    @Override
    public Selection apply(Table relation) {
        CategoryColumn categoryColumn = (CategoryColumn)relation.column(this.columnReference.getColumnName());
        Set<String> firstSet = categoryColumn.asSet();
        firstSet.removeAll((Collection<?>)this.filterColumn.data());
        return categoryColumn.select(firstSet::contains);
    }
}

