/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;

public class AggregateFunctions {
    public static AggregateFunction first = new AggregateFunction(){

        @Override
        public String functionName() {
            return "First";
        }

        @Override
        public double agg(double[] data) {
            return data.length == 0 ? Double.NaN : data[0];
        }
    };
    public static AggregateFunction last = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Last";
        }

        @Override
        public double agg(double[] data) {
            return data.length == 0 ? Double.NaN : data[data.length - 1];
        }
    };
    public static AggregateFunction count = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Count";
        }

        @Override
        public double agg(double[] data) {
            return data.length;
        }
    };
    public static AggregateFunction mean = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Mean";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.mean((double[])data);
        }
    };
    public static AggregateFunction sum = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Sum";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.sum((double[])data);
        }

        @Override
        public double agg(FloatColumn floatColumn) {
            float sum = 0.0f;
            FloatIterator floatIterator = floatColumn.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (value == Float.NaN) continue;
                sum += value;
            }
            return sum;
        }

        @Override
        public double agg(DoubleColumn floatColumn) {
            float sum = 0.0f;
            DoubleIterator doubleIterator = floatColumn.iterator();
            while (doubleIterator.hasNext()) {
                double value = (Double)doubleIterator.next();
                if (value == Double.NaN) continue;
                sum = (float)((double)sum + value);
            }
            return sum;
        }
    };
    public static AggregateFunction median = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Median";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 50.0);
        }
    };
    public static AggregateFunction n = new AggregateFunction(){

        @Override
        public String functionName() {
            return "N";
        }

        @Override
        public double agg(double[] data) {
            return data.length;
        }
    };
    public static AggregateFunction quartile1 = new AggregateFunction(){

        @Override
        public String functionName() {
            return "First Quartile";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 25.0);
        }
    };
    public static AggregateFunction quartile3 = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Third Quartile";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 75.0);
        }
    };
    public static AggregateFunction percentile90 = new AggregateFunction(){

        @Override
        public String functionName() {
            return "90th Percentile";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 90.0);
        }
    };
    public static AggregateFunction percentile95 = new AggregateFunction(){

        @Override
        public String functionName() {
            return "95th Percentile";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 95.0);
        }
    };
    public static AggregateFunction percentile99 = new AggregateFunction(){

        @Override
        public String functionName() {
            return "99th Percentile";
        }

        @Override
        public double agg(double[] data) {
            return AggregateFunctions.percentile(data, 99.0);
        }
    };
    public static AggregateFunction range = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Range";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.max((double[])data) - StatUtils.min((double[])data);
        }
    };
    public static AggregateFunction min = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Min";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.min((double[])data);
        }

        @Override
        public double agg(FloatColumn data) {
            if (data.size() == 0) {
                return Double.NaN;
            }
            float min = data.firstElement();
            FloatIterator floatIterator = data.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (Float.isNaN(value)) continue;
                min = min < value ? min : value;
            }
            return min;
        }
    };
    public static AggregateFunction max = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Max";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.max((double[])data);
        }
    };
    public static AggregateFunction product = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Product";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.product((double[])data);
        }

        @Override
        public double agg(FloatColumn data) {
            float product = 1.0f;
            boolean empty = true;
            FloatIterator floatIterator = data.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                if (value == Float.NaN) continue;
                empty = false;
                product *= value;
            }
            if (empty) {
                return Double.NaN;
            }
            return product;
        }
    };
    public static AggregateFunction geometricMean = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Geometric Mean";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.geometricMean((double[])data);
        }
    };
    public static AggregateFunction populationVariance = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Population Variance";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.populationVariance((double[])data);
        }
    };
    public static AggregateFunction quadraticMean = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Quadratic Mean";
        }

        @Override
        public double agg(double[] data) {
            return new DescriptiveStatistics(data).getQuadraticMean();
        }
    };
    public static AggregateFunction kurtosis = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Kurtosis";
        }

        @Override
        public double agg(double[] data) {
            return new Kurtosis().evaluate(data, 0, data.length);
        }
    };
    public static AggregateFunction skewness = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Skewness";
        }

        @Override
        public double agg(double[] data) {
            return new Skewness().evaluate(data, 0, data.length);
        }
    };
    public static AggregateFunction sumOfSquares = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Sum of Squares";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.sumSq((double[])data);
        }
    };
    public static AggregateFunction sumOfLogs = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Sum of Logs";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.sumLog((double[])data);
        }
    };
    public static AggregateFunction variance = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Variance";
        }

        @Override
        public double agg(double[] data) {
            return StatUtils.variance((double[])data);
        }

        @Override
        public double agg(FloatColumn column) {
            double avg = mean.agg(column);
            double sumSquaredDiffs = 0.0;
            FloatIterator floatIterator = column.iterator();
            while (floatIterator.hasNext()) {
                float value = ((Float)floatIterator.next()).floatValue();
                double diff = (double)value - avg;
                double sqrdDiff = diff * diff;
                sumSquaredDiffs += sqrdDiff;
            }
            return sumSquaredDiffs / (double)(column.size() - 1);
        }
    };
    public static AggregateFunction stdDev = new AggregateFunction(){

        @Override
        public String functionName() {
            return "Std. Deviation";
        }

        @Override
        public double agg(double[] data) {
            return Math.sqrt(StatUtils.variance((double[])data));
        }
    };

    public static double percentile(double[] data, double percentile) {
        return StatUtils.percentile((double[])data, (double)percentile);
    }

    public static double meanDifference(FloatColumn column1, FloatColumn column2) {
        return StatUtils.meanDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }

    public static double sumDifference(FloatColumn column1, FloatColumn column2) {
        return StatUtils.sumDifference((double[])column1.toDoubleArray(), (double[])column2.toDoubleArray());
    }
}

