/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.TimeColumnUtils;
import tech.tablesaw.columns.packeddata.PackedLocalTime;

public interface TimeMapUtils
extends TimeColumnUtils {
    default public LongColumn differenceInMilliseconds(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.MILLIS);
    }

    default public LongColumn differenceInSeconds(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.SECONDS);
    }

    default public LongColumn differenceInMinutes(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.MINUTES);
    }

    default public LongColumn differenceInHours(TimeColumn column2) {
        return this.difference(column2, ChronoUnit.HOURS);
    }

    default public LongColumn difference(TimeColumn column2, ChronoUnit unit) {
        LongColumn newColumn = new LongColumn(this.name() + " - " + column2.name());
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            int c2 = column2.getIntInternal(r);
            if (c1 == TimeColumn.MISSING_VALUE || c2 == TimeColumn.MISSING_VALUE) {
                newColumn.append(IntColumn.MISSING_VALUE);
                continue;
            }
            newColumn.append(this.difference(c1, c2, unit));
        }
        return newColumn;
    }

    default public long difference(int packedLocalTime1, int packedLocalTime2, ChronoUnit unit) {
        LocalTime value1 = PackedLocalTime.asLocalTime(packedLocalTime1);
        LocalTime value2 = PackedLocalTime.asLocalTime(packedLocalTime2);
        return unit.between(value1, value2);
    }

    default public ShortColumn hour() {
        ShortColumn newColumn = new ShortColumn(this.name() + "[hour]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 != TimeColumn.MISSING_VALUE) {
                newColumn.append(PackedLocalTime.getHour(c1));
                continue;
            }
            newColumn.append(ShortColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public IntColumn minuteOfDay() {
        IntColumn newColumn = new IntColumn(this.name() + "[minute-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 != TimeColumn.MISSING_VALUE) {
                newColumn.append(PackedLocalTime.getMinuteOfDay(c1));
                continue;
            }
            newColumn.append(IntColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    default public IntColumn secondOfDay() {
        IntColumn newColumn = new IntColumn(this.name() + "[second-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            int c1 = this.getIntInternal(r);
            if (c1 != TimeColumn.MISSING_VALUE) {
                newColumn.append(PackedLocalTime.getSecondOfDay(c1));
                continue;
            }
            newColumn.append(IntColumn.MISSING_VALUE);
        }
        return newColumn;
    }

    public LocalTime get(int var1);

    public int getIntInternal(int var1);
}

