/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class StringNotEqualTo
extends ColumnFilter {
    private final String value;

    public StringNotEqualTo(ColumnReference reference, String value) {
        super(reference);
        this.value = value;
    }

    @Override
    public Selection apply(Table relation) {
        Column column = relation.column(this.columnReference.getColumnName());
        ColumnType type = column.type();
        switch (type) {
            case CATEGORY: {
                CategoryColumn categoryColumn = (CategoryColumn)relation.column(this.columnReference.getColumnName());
                return categoryColumn.isNotEqualTo(this.value);
            }
        }
        throw new UnsupportedOperationException(String.format("ColumnType %s does not support equalTo on a String value", new Object[]{type}));
    }
}

