/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.packeddata;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.util.Date;

public class PackedLocalDate {
    private static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;

    public static byte getDayOfMonth(int date) {
        return (byte)date;
    }

    public static short getYear(int date) {
        byte byte1 = (byte)(date >> 24);
        byte byte2 = (byte)(date >> 16);
        return (short)((byte2 << 8) + (byte1 & 0xFF));
    }

    public static LocalDate asLocalDate(int date) {
        if (date == Integer.MIN_VALUE) {
            return null;
        }
        byte yearByte1 = (byte)(date >> 24);
        byte yearByte2 = (byte)(date >> 16);
        return LocalDate.of((int)((short)((yearByte2 << 8) + (yearByte1 & 0xFF))), (byte)(date >> 8), (int)((byte)date));
    }

    public static byte getMonthValue(int date) {
        return (byte)(date >> 8);
    }

    public static int pack(LocalDate date) {
        short year = (short)date.getYear();
        byte byte1 = (byte)year;
        byte byte2 = (byte)(year >> 8 & 0xFF);
        return Ints.fromBytes((byte)byte1, (byte)byte2, (byte)((byte)date.getMonthValue()), (byte)((byte)date.getDayOfMonth()));
    }

    public static int pack(Date date) {
        return PackedLocalDate.pack(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public static int pack(short yr, byte m, byte d) {
        byte byte1 = (byte)yr;
        byte byte2 = (byte)(yr >> 8 & 0xFF);
        return Ints.fromBytes((byte)byte1, (byte)byte2, (byte)m, (byte)d);
    }

    public static String toDateString(int date) {
        if (date == Integer.MIN_VALUE) {
            return "NA";
        }
        byte yearByte1 = (byte)(date >> 24);
        byte yearByte2 = (byte)(date >> 16);
        return (short)((yearByte2 << 8) + (yearByte1 & 0xFF)) + "-" + Strings.padStart((String)Byte.toString((byte)(date >> 8)), (int)2, (char)'0') + "-" + Strings.padStart((String)Byte.toString((byte)date), (int)2, (char)'0');
    }

    public static int getDayOfYear(int packedDate) {
        return PackedLocalDate.getMonth(packedDate).firstDayOfYear(PackedLocalDate.isLeapYear(packedDate)) + PackedLocalDate.getDayOfMonth(packedDate) - 1;
    }

    public static boolean isLeapYear(int packedDate) {
        return IsoChronology.INSTANCE.isLeapYear(PackedLocalDate.getYear(packedDate));
    }

    public static Month getMonth(int packedDate) {
        return Month.of(PackedLocalDate.getMonthValue(packedDate));
    }

    public static int lengthOfMonth(int packedDate) {
        switch (PackedLocalDate.getMonthValue(packedDate)) {
            case 2: {
                return PackedLocalDate.isLeapYear(packedDate) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static long toEpochDay(int packedDate) {
        long y = PackedLocalDate.getYear(packedDate);
        long m = PackedLocalDate.getMonthValue(packedDate);
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(PackedLocalDate.getDayOfMonth(packedDate) - 1);
        if (m > 2L) {
            --total;
            if (!PackedLocalDate.isLeapYear(packedDate)) {
                --total;
            }
        }
        return total - 719528L;
    }

    public static DayOfWeek getDayOfWeek(int packedDate) {
        int dow0 = (int)Math.floorMod(PackedLocalDate.toEpochDay(packedDate) + 3L, 7L);
        return DayOfWeek.of(dow0 + 1);
    }

    public static int getQuarter(int packedDate) {
        Month month = PackedLocalDate.getMonth(packedDate);
        switch (month) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                return 1;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                return 2;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                return 3;
            }
            case OCTOBER: 
            case NOVEMBER: 
            case DECEMBER: {
                return 4;
            }
        }
        throw new IllegalStateException("Failed to extract quarter from packedDate");
    }

    public static boolean isInQ1(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 1;
    }

    public static boolean isInQ2(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 2;
    }

    public static boolean isInQ3(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 3;
    }

    public static boolean isInQ4(int packedDate) {
        return PackedLocalDate.getQuarter(packedDate) == 4;
    }

    public static boolean isAfter(int packedDate, int value) {
        return packedDate > value;
    }

    public static boolean isBefore(int packedDate, int value) {
        return packedDate < value;
    }

    public static boolean isOnOrBefore(int packedDate, int value) {
        return packedDate <= value;
    }

    public static boolean isOnOrAfter(int packedDate, int value) {
        return packedDate >= value;
    }

    public static boolean isSunday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.SUNDAY;
    }

    public static boolean isMonday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.MONDAY;
    }

    public static boolean isTuesday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.TUESDAY;
    }

    public static boolean isWednesday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.WEDNESDAY;
    }

    public static boolean isThursday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.THURSDAY;
    }

    public static boolean isFriday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.FRIDAY;
    }

    public static boolean isSaturday(int packedDate) {
        DayOfWeek dayOfWeek = PackedLocalDate.getDayOfWeek(packedDate);
        return dayOfWeek == DayOfWeek.SATURDAY;
    }

    public static boolean isFirstDayOfMonth(int packedDate) {
        return PackedLocalDate.getDayOfMonth(packedDate) == 1;
    }

    public static boolean isInJanuary(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JANUARY;
    }

    public static boolean isInFebruary(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.FEBRUARY;
    }

    public static boolean isInMarch(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.MARCH;
    }

    public static boolean isInApril(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.APRIL;
    }

    public static boolean isInMay(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.MAY;
    }

    public static boolean isInJune(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JUNE;
    }

    public static boolean isInJuly(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.JULY;
    }

    public static boolean isInAugust(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.AUGUST;
    }

    public static boolean isInSeptember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.SEPTEMBER;
    }

    public static boolean isInOctober(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.OCTOBER;
    }

    public static boolean isInNovember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.NOVEMBER;
    }

    public static boolean isInDecember(int packedDate) {
        return PackedLocalDate.getMonth(packedDate) == Month.DECEMBER;
    }

    public static boolean isLastDayOfMonth(int packedDate) {
        return PackedLocalDate.getDayOfMonth(packedDate) == PackedLocalDate.lengthOfMonth(packedDate);
    }

    public static boolean isInYear(int next, int year) {
        return PackedLocalDate.getYear(next) == year;
    }

    public int lengthOfYear(int packedDate) {
        return PackedLocalDate.isLeapYear(packedDate) ? 366 : 365;
    }
}

