/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.util.List;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public class SubTable
extends Table {
    private List<String> values;

    SubTable(Table original) {
        super(original.name(), original.emptyCopy().columns().toArray(new Column[original.columnCount()]));
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    void addRow(int rowIndex, Table sourceTable) {
        block11: for (int i = 0; i < this.columnCount(); ++i) {
            Column column = this.column(i);
            ColumnType type = column.type();
            switch (type) {
                case FLOAT: {
                    FloatColumn floatColumn = (FloatColumn)column;
                    floatColumn.append(sourceTable.floatColumn(i).get(rowIndex));
                    continue block11;
                }
                case INTEGER: {
                    IntColumn intColumn = (IntColumn)column;
                    intColumn.append(sourceTable.intColumn(i).get(rowIndex));
                    continue block11;
                }
                case SHORT_INT: {
                    ShortColumn shortColumn = (ShortColumn)column;
                    shortColumn.append(sourceTable.shortColumn(i).get(rowIndex));
                    continue block11;
                }
                case LONG_INT: {
                    LongColumn longColumn = (LongColumn)column;
                    longColumn.append(sourceTable.longColumn(i).get(rowIndex));
                    continue block11;
                }
                case BOOLEAN: {
                    BooleanColumn booleanColumn = (BooleanColumn)column;
                    booleanColumn.append(sourceTable.booleanColumn(i).get(rowIndex));
                    continue block11;
                }
                case LOCAL_DATE: {
                    DateColumn localDateColumn = (DateColumn)column;
                    localDateColumn.appendInternal(sourceTable.dateColumn(i).getIntInternal(rowIndex));
                    continue block11;
                }
                case LOCAL_TIME: {
                    TimeColumn timeColumn = (TimeColumn)column;
                    timeColumn.appendInternal(sourceTable.timeColumn(i).getIntInternal(rowIndex));
                    continue block11;
                }
                case LOCAL_DATE_TIME: {
                    DateTimeColumn localDateTimeColumn = (DateTimeColumn)column;
                    localDateTimeColumn.appendInternal(sourceTable.dateTimeColumn(i).getLongInternal(rowIndex));
                    continue block11;
                }
                case CATEGORY: {
                    CategoryColumn categoryColumn = (CategoryColumn)column;
                    categoryColumn.add(sourceTable.categoryColumn(i).get(rowIndex));
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Unhandled column type updating columns");
                }
            }
        }
    }
}

