/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.io.ByteArrayOutputStream;
import java.util.List;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.string.DataFramePrinter;

public abstract class Relation {
    public abstract Relation addColumn(Column ... var1);

    public abstract Relation setName(String var1);

    public boolean isEmpty() {
        return this.rowCount() == 0;
    }

    public String shape() {
        return this.rowCount() + " rows X " + this.columnCount() + " cols";
    }

    public Relation removeColumn(int columnIndex) {
        this.removeColumns(this.column(columnIndex));
        return this;
    }

    public abstract Relation removeColumns(Column ... var1);

    public Relation removeColumns(String ... columnName) {
        Column[] cols = new Column[columnName.length];
        for (int i = 0; i < columnName.length; ++i) {
            cols[i] = this.column(columnName[i]);
        }
        this.removeColumns(cols);
        return this;
    }

    public abstract Table first(int var1);

    public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnCount(); ++i) {
            if (!this.columnNames().get(i).equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name()));
        }
        return columnIndex;
    }

    public Column column(String columnName) {
        Column result = null;
        for (Column column : this.columns()) {
            String name = column.name().trim();
            if (!name.equalsIgnoreCase(columnName)) continue;
            result = column;
            break;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Column %s does not exist in table %s", columnName, this.name()));
        }
        return result;
    }

    public abstract Column column(int var1);

    public abstract int columnCount();

    public abstract int rowCount();

    public abstract List<Column> columns();

    public abstract int columnIndex(Column var1);

    public abstract String get(int var1, int var2);

    public abstract String name();

    public abstract void clear();

    public abstract List<String> columnNames();

    public ColumnType[] columnTypes() {
        ColumnType[] columnTypes = new ColumnType[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes[i] = this.columns().get(i).type();
        }
        return columnTypes;
    }

    public int[] colWidths() {
        int cols = this.columnCount();
        int[] widths = new int[cols];
        for (int i = 0; i < this.columnCount(); ++i) {
            widths[i] = this.columns().get(i).columnWidth();
        }
        return widths;
    }

    public String toString() {
        return "Table " + this.name() + ": Size = " + this.rowCount() + " x " + this.columnCount();
    }

    public String print(int rowLimit) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataFramePrinter printer = new DataFramePrinter(rowLimit, baos);
        printer.print(this);
        return new String(baos.toByteArray());
    }

    public String print() {
        return this.print(20);
    }

    public Table structure() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("Table: ").append(this.name()).append(" - ").append(this.rowCount()).append(" observations (rows) of ").append(this.columnCount()).append(" variables (cols)");
        Table structure = Table.create(nameBuilder.toString());
        structure.addColumn(new IntColumn("Index"));
        structure.addColumn(new CategoryColumn("Column Name"));
        structure.addColumn(new CategoryColumn("Type"));
        structure.addColumn(new IntColumn("Unique Values"));
        structure.addColumn(new CategoryColumn("First"));
        structure.addColumn(new CategoryColumn("Last"));
        for (Column column : this.columns()) {
            structure.intColumn("Index").append(this.columnIndex(column));
            structure.categoryColumn("Column Name").add(column.name());
            structure.categoryColumn("Type").add(column.type().name());
            structure.intColumn("Unique Values").append(column.countUnique());
            structure.categoryColumn("First").add(column.first());
            structure.categoryColumn("Last").add(column.getString(column.size() - 1));
        }
        return structure;
    }

    public String summary() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("Table summary for: ").append(this.name()).append("\n");
        for (Column column : this.columns()) {
            builder.append(column.summary().print());
            builder.append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    public BooleanColumn booleanColumn(int columnIndex) {
        return (BooleanColumn)this.column(columnIndex);
    }

    public BooleanColumn booleanColumn(String columnName) {
        return (BooleanColumn)this.column(columnName);
    }

    public NumericColumn numericColumn(int columnIndex) {
        Column c = this.column(columnIndex);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnIndex);
    }

    public NumericColumn numericColumn(String columnName) {
        Column c = this.column(columnName);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnName);
    }

    public NumericColumn nCol(String columnName) {
        return this.numericColumn(columnName);
    }

    public NumericColumn nCol(int columnIndex) {
        return this.numericColumn(columnIndex);
    }

    public FloatColumn floatColumn(int columnIndex) {
        return (FloatColumn)this.column(columnIndex);
    }

    public FloatColumn floatColumn(String columnName) {
        return (FloatColumn)this.column(columnName);
    }

    public DoubleColumn doubleColumn(int columnIndex) {
        return (DoubleColumn)this.column(columnIndex);
    }

    public DoubleColumn doubleColumn(String columnName) {
        return (DoubleColumn)this.column(columnName);
    }

    public IntColumn intColumn(String columnName) {
        return (IntColumn)this.column(columnName);
    }

    public IntColumn intColumn(int columnIndex) {
        return (IntColumn)this.column(columnIndex);
    }

    public ShortColumn shortColumn(String columnName) {
        return (ShortColumn)this.column(columnName);
    }

    public ShortColumn shortColumn(int columnIndex) {
        return (ShortColumn)this.column(columnIndex);
    }

    public LongColumn longColumn(String columnName) {
        return (LongColumn)this.column(columnName);
    }

    public LongColumn longColumn(int columnIndex) {
        return (LongColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(int columnIndex) {
        return (DateColumn)this.column(columnIndex);
    }

    public DateColumn dateColumn(String columnName) {
        return (DateColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(String columnName) {
        return (TimeColumn)this.column(columnName);
    }

    public TimeColumn timeColumn(int columnIndex) {
        return (TimeColumn)this.column(columnIndex);
    }

    public CategoryColumn categoryColumn(String columnName) {
        return (CategoryColumn)this.column(columnName);
    }

    public CategoryColumn categoryColumn(int columnIndex) {
        return (CategoryColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(int columnIndex) {
        return (DateTimeColumn)this.column(columnIndex);
    }

    public DateTimeColumn dateTimeColumn(String columnName) {
        return (DateTimeColumn)this.column(columnName);
    }
}

