/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import org.roaringbitmap.RoaringBitmap;
import tech.tablesaw.util.Selection;

public class BitmapBackedSelection
implements Selection {
    private final RoaringBitmap bitmap;

    public BitmapBackedSelection(RoaringBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public BitmapBackedSelection() {
        this.bitmap = new RoaringBitmap();
    }

    @Override
    public void add(int i) {
        this.bitmap.add(i);
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public int[] toArray() {
        return this.bitmap.toArray();
    }

    @Override
    public RoaringBitmap toBitmap() {
        return this.bitmap.clone();
    }

    @Override
    public IntArrayList toIntArrayList() {
        return new IntArrayList(this.bitmap.toArray());
    }

    @Override
    public void and(Selection otherSelection) {
        this.bitmap.and(otherSelection.toBitmap());
    }

    @Override
    public void or(Selection otherSelection) {
        this.bitmap.or(otherSelection.toBitmap());
    }

    @Override
    public void andNot(Selection otherSelection) {
        this.bitmap.andNot(otherSelection.toBitmap());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public boolean contains(int i) {
        return this.bitmap.contains(i);
    }

    @Override
    public void addRange(int start, int end) {
        this.bitmap.add(start, end);
    }

    @Override
    public int get(int i) {
        return this.bitmap.select(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapBackedSelection integers = (BitmapBackedSelection)o;
        return this.bitmap.equals((Object)integers.bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private final org.roaringbitmap.IntIterator iterator;
            {
                this.iterator = BitmapBackedSelection.this.bitmap.getIntIterator();
            }

            public int nextInt() {
                return this.iterator.next();
            }

            public int skip(int k) {
                throw new UnsupportedOperationException("Views do not support skipping in the iterator");
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Integer next() {
                return this.iterator.next();
            }
        };
    }
}

