/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.util.BitmapBackedSelection;

public class RollingColumn {
    private final Column column;
    private final int window;

    public RollingColumn(Column column, int window) {
        this.column = column;
        this.window = window;
    }

    public DoubleColumn mean() {
        return this.calc(AggregateFunctions.mean);
    }

    public DoubleColumn sum(String resultColName) {
        return this.calc(AggregateFunctions.sum);
    }

    private String generateNewColumnName(AggregateFunction function) {
        boolean useSpaces = this.column.name().matches("\\s+");
        String separator = useSpaces ? " " : "";
        String newColumnName = this.column.name() + separator + (useSpaces ? function.functionName() : StringUtils.capitalize((String)function.functionName())) + separator + this.window;
        return newColumnName;
    }

    public DoubleColumn calc(AggregateFunction function) {
        DoubleColumn result = new DoubleColumn(this.generateNewColumnName(function), this.column.size());
        for (int i = 0; i < this.window - 1; ++i) {
            result.append(DoubleColumn.MISSING_VALUE);
        }
        for (int origColIndex = 0; origColIndex < this.column.size() - this.window + 1; ++origColIndex) {
            double calc;
            BitmapBackedSelection selection = new BitmapBackedSelection();
            selection.addRange(origColIndex, origColIndex + this.window);
            Column windowedColumn = this.column.subset(selection);
            if (windowedColumn instanceof DoubleColumn) {
                calc = function.agg((DoubleColumn)windowedColumn);
            } else if (windowedColumn instanceof FloatColumn) {
                calc = function.agg((FloatColumn)windowedColumn);
            } else if (windowedColumn instanceof IntColumn) {
                calc = function.agg((IntColumn)windowedColumn);
            } else if (windowedColumn instanceof LongColumn) {
                calc = function.agg((LongColumn)windowedColumn);
            } else if (windowedColumn instanceof ShortColumn) {
                calc = function.agg((ShortColumn)windowedColumn);
            } else {
                throw new IllegalArgumentException("Cannot calculate " + function.functionName() + " on column of type " + (Object)((Object)windowedColumn.type()));
            }
            result.append(calc);
        }
        return result;
    }
}

