/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering.text;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.columns.CategoryColumnUtils;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.DictionaryMap;
import tech.tablesaw.util.Selection;

public interface CategoryFilters
extends CategoryColumnUtils {
    default public Selection equalToIgnoringCase(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.endsWith(string)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection startsWith(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        IntRBTreeSet sorted = new IntRBTreeSet();
        DictionaryMap dictionaryMap = this.dictionaryMap();
        for (Object2IntMap.Entry entry : dictionaryMap.valueToKeyMap().object2IntEntrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(string)) continue;
            sorted.add(entry.getIntValue());
        }
        int i = 0;
        IntListIterator intListIterator = this.values().iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (sorted.contains(next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection endsWith(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.endsWith(string)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection stringContains(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.contains(string)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection matchesRegex(String string) {
        Pattern p = Pattern.compile(string);
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            Matcher m = p.matcher(next);
            if (m.matches()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection empty() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.isEmpty()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isAlpha() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (StringUtils.isAlpha((CharSequence)next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isNumeric() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (StringUtils.isNumeric((CharSequence)next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isAlphaNumeric() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (StringUtils.isAlphanumeric((CharSequence)next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isUpperCase() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (StringUtils.isAllUpperCase((CharSequence)next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isLowerCase() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (StringUtils.isAllLowerCase((CharSequence)next)) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection hasLengthEqualTo(int lengthChars) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.length() == lengthChars) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isShorterThan(int lengthChars) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.length() < lengthChars) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isLongerThan(int lengthChars) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        for (String next : this) {
            if (next.length() > lengthChars) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }
}

