/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.filtering;

import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.ColumnReference;
import tech.tablesaw.filtering.ColumnFilter;
import tech.tablesaw.util.Selection;

public class IntBetweenInclusive
extends ColumnFilter {
    private final int low;
    private final int high;

    public IntBetweenInclusive(ColumnReference reference, int lowValue, int highValue) {
        super(reference);
        this.low = lowValue;
        this.high = highValue;
    }

    @Override
    public Selection apply(Table relation) {
        IntColumn intColumn = (IntColumn)relation.column(this.columnReference.getColumnName());
        Selection matches = intColumn.isGreaterThanOrEqualTo(this.low);
        matches.toBitmap().and(intColumn.isLessThanOrEqualTo(this.high).toBitmap());
        return matches;
    }
}

