/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.packeddata;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.util.Date;
import tech.tablesaw.columns.packeddata.PackedLocalDate;
import tech.tablesaw.columns.packeddata.PackedLocalTime;

public class PackedLocalDateTime {
    private PackedLocalDateTime() {
    }

    public static byte getDayOfMonth(long date) {
        return (byte)PackedLocalDateTime.date(date);
    }

    public static short getYear(int date) {
        byte byte1 = (byte)(date >> 24);
        byte byte2 = (byte)(date >> 16);
        return (short)((byte2 << 8) + (byte1 & 0xFF));
    }

    public static short getYear(long dateTime) {
        return PackedLocalDateTime.getYear(PackedLocalDateTime.date(dateTime));
    }

    public static LocalDateTime asLocalDateTime(long dateTime) {
        if (dateTime == Long.MIN_VALUE) {
            return null;
        }
        int date = PackedLocalDateTime.date(dateTime);
        int time = PackedLocalDateTime.time(dateTime);
        return LocalDateTime.of(PackedLocalDate.asLocalDate(date), PackedLocalTime.asLocalTime(time));
    }

    public static byte getMonthValue(long dateTime) {
        int date = PackedLocalDateTime.date(dateTime);
        return (byte)(date >> 8);
    }

    public static long pack(LocalDate date, LocalTime time) {
        int d = PackedLocalDate.pack(date);
        int t = PackedLocalTime.pack(time);
        return (long)d << 32 | (long)t & 0xFFFFFFFFL;
    }

    public static long pack(LocalDateTime dateTime) {
        LocalDate date = dateTime.toLocalDate();
        LocalTime time = dateTime.toLocalTime();
        int d = PackedLocalDate.pack(date);
        int t = PackedLocalTime.pack(time);
        return (long)d << 32 | (long)t & 0xFFFFFFFFL;
    }

    public static long pack(Date date) {
        return PackedLocalDateTime.pack(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    public static long pack(short yr, byte m, byte d, byte hr, byte min, byte s, byte n) {
        byte byte1 = (byte)yr;
        byte byte2 = (byte)(yr >> 8 & 0xFF);
        int date = Ints.fromBytes((byte)byte1, (byte)byte2, (byte)m, (byte)d);
        int time = Ints.fromBytes((byte)hr, (byte)min, (byte)s, (byte)n);
        return (long)date << 32 | (long)time & 0xFFFFFFFFL;
    }

    public static int date(long packedDateTIme) {
        return (int)(packedDateTIme >> 32);
    }

    public static int time(long packedDateTIme) {
        return (int)packedDateTIme;
    }

    public static String toString(long dateTime) {
        if (dateTime == Long.MIN_VALUE) {
            return "NA";
        }
        int date = PackedLocalDateTime.date(dateTime);
        int time = PackedLocalDateTime.time(dateTime);
        byte yearByte1 = (byte)(date >> 24);
        byte yearByte2 = (byte)(date >> 16);
        return "" + (short)((yearByte2 << 8) + (yearByte1 & 0xFF)) + "-" + Strings.padStart((String)Byte.toString((byte)(date >> 8)), (int)2, (char)'0') + "-" + Strings.padStart((String)Byte.toString((byte)date), (int)2, (char)'0') + "T" + Strings.padStart((String)Byte.toString(PackedLocalTime.getHour(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getMinute(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getSecond(time)), (int)2, (char)'0') + "." + Strings.padStart((String)String.valueOf(PackedLocalTime.getMilliseconds(time)), (int)3, (char)'0');
    }

    public static int getDayOfYear(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime).firstDayOfYear(PackedLocalDateTime.isLeapYear(packedDateTime)) + PackedLocalDateTime.getDayOfMonth(packedDateTime) - 1;
    }

    public static boolean isLeapYear(long packedDateTime) {
        return IsoChronology.INSTANCE.isLeapYear(PackedLocalDateTime.getYear(packedDateTime));
    }

    public static Month getMonth(long packedDateTime) {
        return Month.of(PackedLocalDateTime.getMonthValue(packedDateTime));
    }

    public static int lengthOfMonth(long packedDateTime) {
        switch (PackedLocalDateTime.getMonthValue(packedDateTime)) {
            case 2: {
                return PackedLocalDateTime.isLeapYear(packedDateTime) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static DayOfWeek getDayOfWeek(long packedDateTime) {
        int date = PackedLocalDateTime.date(packedDateTime);
        return PackedLocalDate.getDayOfWeek(date);
    }

    public static boolean isInQ1(long packedDateTime) {
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.JANUARY || month == Month.FEBRUARY || month == Month.MARCH;
    }

    public static boolean isInQ2(long packedDateTime) {
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.APRIL || month == Month.MAY || month == Month.JUNE;
    }

    public static boolean isInQ3(long packedDateTime) {
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.JULY || month == Month.AUGUST || month == Month.SEPTEMBER;
    }

    public static boolean isInQ4(long packedDateTime) {
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.OCTOBER || month == Month.NOVEMBER || month == Month.DECEMBER;
    }

    public static boolean isAfter(long packedDateTime, long value) {
        return packedDateTime > value;
    }

    public static boolean isBefore(long packedDateTime, long value) {
        return packedDateTime < value;
    }

    public static boolean isSunday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.SUNDAY;
    }

    public static boolean isMonday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.MONDAY;
    }

    public static boolean isTuesday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.TUESDAY;
    }

    public static boolean isWednesday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.WEDNESDAY;
    }

    public static boolean isThursday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.THURSDAY;
    }

    public static boolean isFriday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.FRIDAY;
    }

    public static boolean isSaturday(long packedDateTime) {
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.SATURDAY;
    }

    public static boolean isFirstDayOfMonth(long packedDateTime) {
        return PackedLocalDateTime.getDayOfMonth(packedDateTime) == 1;
    }

    public static boolean isInJanuary(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.JANUARY;
    }

    public static boolean isInFebruary(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.FEBRUARY;
    }

    public static boolean isInMarch(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.MARCH;
    }

    public static boolean isInApril(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.APRIL;
    }

    public static boolean isInMay(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.MAY;
    }

    public static boolean isInJune(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.JUNE;
    }

    public static boolean isInJuly(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.JULY;
    }

    public static boolean isInAugust(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.AUGUST;
    }

    public static boolean isInSeptember(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.SEPTEMBER;
    }

    public static boolean isInOctober(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.OCTOBER;
    }

    public static boolean isInNovember(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.NOVEMBER;
    }

    public static boolean isInDecember(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime) == Month.DECEMBER;
    }

    public static boolean isLastDayOfMonth(long packedDateTime) {
        return PackedLocalDateTime.getDayOfMonth(packedDateTime) == PackedLocalDateTime.lengthOfMonth(packedDateTime);
    }

    public static boolean isInYear(long packedDateTime, int year) {
        return PackedLocalDateTime.getYear(packedDateTime) == year;
    }

    public static boolean isMidnight(long packedDateTime) {
        return PackedLocalTime.isMidnight(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean isNoon(long packedDateTime) {
        return PackedLocalTime.isNoon(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean AM(long packedDateTime) {
        return PackedLocalTime.AM(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean PM(long packedDateTime) {
        return PackedLocalTime.PM(PackedLocalDateTime.time(packedDateTime));
    }

    public static int getMinuteOfDay(long packedLocalDateTime) {
        return PackedLocalDateTime.getHour(packedLocalDateTime) * 60 + PackedLocalDateTime.getMinute(packedLocalDateTime);
    }

    public static byte getSecond(int packedLocalDateTime) {
        return (byte)(PackedLocalDateTime.getMillisecondOfMinute(packedLocalDateTime) / 1000);
    }

    public static byte getHour(long packedLocalDateTime) {
        return PackedLocalTime.getHour(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static byte getMinute(long packedLocalDateTime) {
        return PackedLocalTime.getMinute(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static byte getSecond(long packedLocalDateTime) {
        return PackedLocalTime.getSecond(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static int getSecondOfDay(long packedLocalDateTime) {
        return PackedLocalTime.getSecondOfDay(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static short getMillisecondOfMinute(long packedLocalDateTime) {
        LocalDateTime localDateTime = LocalDateTime.now();
        short total = (short)localDateTime.get(ChronoField.MILLI_OF_SECOND);
        total = (short)(total + localDateTime.getSecond() * 1000);
        return total;
    }

    public static long getMillisecondOfDay(long packedLocalDateTime) {
        LocalDateTime localDateTime = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime);
        long total = localDateTime.get(ChronoField.MILLI_OF_SECOND);
        total += (long)(localDateTime.getSecond() * 1000);
        total += (long)(localDateTime.getMinute() * 60 * 1000);
        return total += (long)(localDateTime.getHour() * 60 * 60 * 1000);
    }

    public static long create(int date, int time) {
        return (long)date << 32 | (long)time & 0xFFFFFFFFL;
    }

    public static long toEpochMilli(long packedLocalDateTime, ZoneOffset offset) {
        LocalDateTime dateTime = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime);
        Instant instant = dateTime.toInstant(offset);
        return instant.toEpochMilli();
    }

    public static long ofEpochMilli(long millisecondsSinceEpoch, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(millisecondsSinceEpoch);
        return PackedLocalDateTime.pack(LocalDateTime.ofInstant(instant, zoneId));
    }

    public int lengthOfYear(long packedDateTime) {
        return PackedLocalDateTime.isLeapYear(packedDateTime) ? 366 : 365;
    }
}

