/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.packeddata.PackedLocalTime;
import tech.tablesaw.filtering.IntBiPredicate;
import tech.tablesaw.filtering.IntPredicate;
import tech.tablesaw.filtering.LocalTimePredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.TimeMapUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseIntComparator;
import tech.tablesaw.util.Selection;

public class TimeColumn
extends AbstractColumn
implements Iterable<LocalTime>,
TimeMapUtils {
    public static final int MISSING_VALUE = (Integer)ColumnType.LOCAL_TIME.getMissingValue();
    private static final int BYTE_SIZE = 4;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private IntComparator reverseIntComparator = new IntComparator(){

        public int compare(Integer o2, Integer o1) {
            return o1 < o2 ? -1 : (o1.equals(o2) ? 0 : 1);
        }

        public int compare(int o2, int o1) {
            return o1 < o2 ? -1 : (o1 == o2 ? 0 : 1);
        }
    };
    private DateTimeFormatter selectedFormatter;
    private IntArrayList data;
    IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        public int compare(int r1, int r2) {
            int f1 = TimeColumn.this.getIntInternal(r1);
            int f2 = TimeColumn.this.getIntInternal(r2);
            return Integer.compare(f1, f2);
        }
    };

    public TimeColumn(String name) {
        super(name);
        this.data = new IntArrayList(DEFAULT_ARRAY_SIZE);
    }

    public TimeColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new IntArrayList(DEFAULT_ARRAY_SIZE);
    }

    public TimeColumn(String name, int initialSize) {
        super(name);
        this.data = new IntArrayList(initialSize);
    }

    private TimeColumn(String name, IntArrayList times) {
        super(name);
        this.data = times;
    }

    public TimeColumn(String name, List<LocalTime> data) {
        this(name);
        for (LocalTime time : data) {
            this.append(time);
        }
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public void appendInternal(int f) {
        this.data.add(f);
    }

    public void append(LocalTime f) {
        this.data.add(PackedLocalTime.pack(f));
    }

    @Override
    public ColumnType type() {
        return ColumnType.LOCAL_TIME;
    }

    @Override
    public String getString(int row) {
        return PackedLocalTime.toShortTimeString(this.getIntInternal(row));
    }

    @Override
    public TimeColumn emptyCopy() {
        TimeColumn column = new TimeColumn(this.name(), DEFAULT_ARRAY_SIZE);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public TimeColumn emptyCopy(int rowSize) {
        TimeColumn column = new TimeColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public TimeColumn copy() {
        TimeColumn column = new TimeColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.reverseIntComparator);
    }

    public LocalTime max() {
        int missing = Integer.MIN_VALUE;
        if (this.isEmpty()) {
            return null;
        }
        int max = this.getIntInternal(0);
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (missing == aData) continue;
            max = max > aData ? max : aData;
        }
        if (missing == max) {
            return null;
        }
        return PackedLocalTime.asLocalTime(max);
    }

    public LocalTime min() {
        int missing = Integer.MIN_VALUE;
        if (this.isEmpty()) {
            return null;
        }
        int min = this.getIntInternal(0);
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (missing == aData) continue;
            min = min < aData ? min : aData;
        }
        if (Integer.MIN_VALUE == min) {
            return null;
        }
        return PackedLocalTime.asLocalTime(min);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        CategoryColumn measure = new CategoryColumn("Measure");
        CategoryColumn value = new CategoryColumn("Value");
        table.addColumn(measure);
        table.addColumn(value);
        measure.add("Count");
        value.add(String.valueOf(this.size()));
        measure.add("Missing");
        value.add(String.valueOf(this.countMissing()));
        measure.add("Earliest");
        value.add(String.valueOf(this.min()));
        measure.add("Latest");
        value.add(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        IntOpenHashSet ints = new IntOpenHashSet((IntCollection)this.data);
        return ints.size();
    }

    @Override
    public TimeColumn unique() {
        IntOpenHashSet ints = new IntOpenHashSet((IntCollection)this.data);
        return new TimeColumn(this.name() + " Unique values", IntArrayList.wrap((int[])ints.toIntArray()));
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int convert(String value) {
        LocalTime time;
        if (Strings.isNullOrEmpty((String)value) || TypeUtils.MISSING_INDICATORS.contains((Object)value) || value.equals("-1")) {
            return (Integer)ColumnType.LOCAL_TIME.getMissingValue();
        }
        value = Strings.padStart((String)value, (int)4, (char)'0');
        if (this.selectedFormatter == null) {
            this.selectedFormatter = TypeUtils.getTimeFormatter(value);
        }
        try {
            time = LocalTime.parse(value, this.selectedFormatter);
        }
        catch (DateTimeParseException e) {
            this.selectedFormatter = TypeUtils.TIME_FORMATTER;
            time = LocalTime.parse(value, this.selectedFormatter);
        }
        return PackedLocalTime.pack(time);
    }

    @Override
    public void appendCell(String object) {
        Preconditions.checkNotNull((Object)object);
        this.appendInternal(this.convert(object));
    }

    @Override
    public int getIntInternal(int index) {
        return this.data.getInt(index);
    }

    @Override
    public LocalTime get(int index) {
        return PackedLocalTime.asLocalTime(this.getIntInternal(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public Selection isNotEqualTo(LocalTime value) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int packedLocalTime = PackedLocalTime.pack(value);
        int i = 0;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (packedLocalTime != next) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isEqualTo(LocalTime value) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int packedLocalTime = PackedLocalTime.pack(value);
        int i = 0;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            if (packedLocalTime == next) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int next = (Integer)intListIterator.next();
            builder.append(String.valueOf(PackedLocalTime.asLocalTime(next)));
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public IntArrayList data() {
        return this.data;
    }

    public String toString() {
        return "LocalTime column: " + this.name();
    }

    public TimeColumn selectIf(LocalTimePredicate predicate) {
        TimeColumn column = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!predicate.test(PackedLocalTime.asLocalTime(next))) continue;
            column.appendInternal(next);
        }
        return column;
    }

    public TimeColumn selectIf(IntPredicate predicate) {
        TimeColumn column = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (!predicate.test(next)) continue;
            column.appendInternal(next);
        }
        return column;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        TimeColumn intColumn = (TimeColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.appendInternal(intColumn.getIntInternal(i));
        }
    }

    public Selection isMidnight() {
        return this.select(PackedLocalTime::isMidnight);
    }

    public Selection isNoon() {
        return this.select(PackedLocalTime::isNoon);
    }

    public Selection isBefore(LocalTime time) {
        return this.select(PackedLocalTime::isBefore, PackedLocalTime.pack(time));
    }

    public Selection isBefore(int packedTime) {
        return this.select(PackedLocalTime::isBefore, packedTime);
    }

    public Selection isAfter(LocalTime time) {
        return this.select(PackedLocalTime::isAfter, PackedLocalTime.pack(time));
    }

    public Selection isAfter(int packedTime) {
        return this.select(PackedLocalTime::isAfter, packedTime);
    }

    public Selection isOnOrAfter(LocalTime time) {
        int packed = PackedLocalTime.pack(time);
        return this.select(PackedLocalTime::isOnOrBefore, packed);
    }

    public Selection isOnOrAfter(int packed) {
        return this.select(PackedLocalTime::isOnOrBefore, packed);
    }

    public Selection isOnOrBefore(LocalTime value) {
        int packed = PackedLocalTime.pack(value);
        return this.select(PackedLocalTime::isOnOrBefore, packed);
    }

    public Selection isOnOrBefore(int packed) {
        return this.select(PackedLocalTime::isOnOrBefore, packed);
    }

    public Selection isBeforeNoon() {
        return this.select(PackedLocalTime::AM);
    }

    public Selection isAfterNoon() {
        return this.select(PackedLocalTime::PM);
    }

    public List<LocalTime> top(int n) {
        ArrayList<LocalTime> top = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)ReverseIntComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalTime.asLocalTime(values[i]));
        }
        return top;
    }

    public List<LocalTime> bottom(int n) {
        ArrayList<LocalTime> bottom = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedLocalTime.asLocalTime(values[i]));
        }
        return bottom;
    }

    public IntIterator intIterator() {
        return this.data.iterator();
    }

    public Selection select(IntPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection select(IntBiPredicate predicate, int value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next, value)) continue;
            selection.add(idx);
        }
        return selection;
    }

    Set<LocalTime> asSet() {
        HashSet<LocalTime> times = new HashSet<LocalTime>();
        TimeColumn unique = this.unique();
        for (LocalTime t : unique) {
            times.add(t);
        }
        return times;
    }

    public boolean contains(LocalTime time) {
        int t = PackedLocalTime.pack(time);
        return this.data().contains(t);
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.getIntInternal(rowNumber)).array();
    }

    @Override
    public Iterator<LocalTime> iterator() {
        return new Iterator<LocalTime>(){
            IntIterator intIterator;
            {
                this.intIterator = TimeColumn.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.intIterator.hasNext();
            }

            @Override
            public LocalTime next() {
                return PackedLocalTime.asLocalTime(this.intIterator.nextInt());
            }
        };
    }
}

