/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import tech.tablesaw.aggregate.AggregateFunction;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.SummaryFunction;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.Filter;
import tech.tablesaw.io.DataFrameReader;
import tech.tablesaw.io.DataFrameWriter;
import tech.tablesaw.io.html.HtmlTableWriter;
import tech.tablesaw.sorting.Sort;
import tech.tablesaw.store.StorageManager;
import tech.tablesaw.store.TableMetadata;
import tech.tablesaw.table.Projection;
import tech.tablesaw.table.Relation;
import tech.tablesaw.table.Rows;
import tech.tablesaw.table.ViewGroup;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.IntComparatorChain;
import tech.tablesaw.util.ReversingIntComparator;
import tech.tablesaw.util.Selection;

public class Table
extends Relation
implements IntIterable {
    private final List<Column> columnList = new ArrayList<Column>();
    private String name;

    private Table(String name) {
        this.name = name;
    }

    private Table(TableMetadata metadata) {
        this.name = metadata.getName();
    }

    protected Table(String name, Column ... columns) {
        this(name);
        for (Column column : columns) {
            this.addColumn(column);
        }
    }

    public static Table create(String tableName) {
        return new Table(tableName);
    }

    public static Table create(TableMetadata metadata) {
        return new Table(metadata);
    }

    public static Table create(String tableName, Column ... columns) {
        return new Table(tableName, columns);
    }

    private static Sort first(String columnName, Sort.Order order) {
        return Sort.on(columnName, order);
    }

    @VisibleForTesting
    public static Sort getSort(String ... columnNames) {
        Sort key = null;
        for (String s : columnNames) {
            if (key == null) {
                key = Table.first(s, Sort.Order.DESCEND);
                continue;
            }
            key.next(s, Sort.Order.DESCEND);
        }
        return key;
    }

    public static Table readTable(String tableNameAndPath) {
        Table t;
        try {
            t = StorageManager.readTable(tableNameAndPath);
        }
        catch (IOException e) {
            System.err.println("Unable to load table from Tablesaw table format");
            e.printStackTrace();
            return null;
        }
        return t;
    }

    public static DataFrameReader read() {
        return new DataFrameReader();
    }

    public DataFrameWriter write() {
        return new DataFrameWriter(this);
    }

    static int[] generateUniformBitmap(int N, int Max) {
        if (N > Max) {
            throw new IllegalArgumentException("Illegal arguments: N (" + N + ") greater than Max (" + Max + ")");
        }
        int[] ans = new int[N];
        if (N == Max) {
            for (int k = 0; k < N; ++k) {
                ans[k] = k;
            }
            return ans;
        }
        BitSet bs = new BitSet(Max);
        int cardinality = 0;
        while (cardinality < N) {
            int v = RandomUtils.nextInt((int)0, (int)Max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ans[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        return ans;
    }

    @Override
    public Table addColumn(Column ... cols) {
        for (Column c : cols) {
            this.validateColumn(c);
            this.columnList.add(c);
        }
        return this;
    }

    private void validateColumn(Column newColumn) {
        Preconditions.checkNotNull((Object)newColumn, (Object)("Attempted to add a null to the columns in table " + this.name));
        ArrayList<String> stringList = new ArrayList<String>();
        for (String name : this.columnNames()) {
            stringList.add(name.toLowerCase());
        }
        if (stringList.contains(newColumn.name().toLowerCase())) {
            String message = String.format("Cannot add column with duplicate name %s to table %s", newColumn, this.name);
            throw new IllegalArgumentException(message);
        }
    }

    public Table addColumn(int index, Column column) {
        this.validateColumn(column);
        this.columnList.add(index, column);
        return this;
    }

    @Override
    public Table setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Column column(int columnIndex) {
        return this.columnList.get(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.columnList.size();
    }

    @Override
    public int rowCount() {
        int result = 0;
        if (!this.columnList.isEmpty()) {
            result = this.columnList.get(0).size();
        }
        return result;
    }

    @Override
    public List<Column> columns() {
        return this.columnList;
    }

    public List<Column> columns(String ... columnNames) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String columnName : columnNames) {
            columns.add(this.column(columnName));
        }
        return columns;
    }

    @Override
    public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).name().equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name));
        }
        return columnIndex;
    }

    @Override
    public int columnIndex(Column column) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnList.size(); ++i) {
            if (!this.columnList.get(i).equals(column)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", column.name(), this.name));
        }
        return columnIndex;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<String> columnNames() {
        ArrayList<String> names = new ArrayList<String>(this.columnList.size());
        names.addAll(this.columnList.stream().map(Column::name).collect(Collectors.toList()));
        return names;
    }

    @Override
    public String get(int r, int c) {
        Column column = this.column(c);
        return column.getString(r);
    }

    public Table fullCopy() {
        Table copy = new Table(this.name);
        for (Column column : this.columnList) {
            copy.addColumn(column.emptyCopy());
        }
        IntArrayList integers = new IntArrayList();
        for (int i = 0; i < this.rowCount(); ++i) {
            integers.add(i);
        }
        Rows.copyRowsToTable(integers, this, copy);
        return copy;
    }

    public Table emptyCopy() {
        Table copy = new Table(this.name);
        for (Column column : this.columnList) {
            copy.addColumn(column.emptyCopy());
        }
        return copy;
    }

    public Table emptyCopy(int rowSize) {
        Table copy = new Table(this.name);
        for (Column column : this.columnList) {
            copy.addColumn(column.emptyCopy(rowSize));
        }
        return copy;
    }

    public Table[] sampleSplit(double table1Proportion) {
        Table[] tables = new Table[2];
        int table1Count = (int)Math.round((double)this.rowCount() * table1Proportion);
        BitmapBackedSelection table2Selection = new BitmapBackedSelection();
        for (int i = 0; i < this.rowCount(); ++i) {
            table2Selection.add(i);
        }
        BitmapBackedSelection table1Selection = new BitmapBackedSelection();
        int[] table1Records = Table.generateUniformBitmap(table1Count, this.rowCount());
        for (int i = 0; i < table1Records.length; ++i) {
            table1Selection.add(table1Records[i]);
        }
        table2Selection.andNot(table1Selection);
        tables[0] = this.selectWhere(table1Selection);
        tables[1] = this.selectWhere(table2Selection);
        return tables;
    }

    public Table sample(double proportion) {
        int[] selectedRecords;
        int tableCount = (int)Math.round((double)this.rowCount() * proportion);
        BitmapBackedSelection table1Selection = new BitmapBackedSelection();
        for (int selectedRecord : selectedRecords = Table.generateUniformBitmap(tableCount, this.rowCount())) {
            table1Selection.add(selectedRecord);
        }
        return this.selectWhere(table1Selection);
    }

    @Override
    public void clear() {
        this.columnList.forEach(Column::clear);
    }

    @Override
    public Table first(int nRows) {
        nRows = Math.min(nRows, this.rowCount());
        Table newTable = this.emptyCopy(nRows);
        Rows.head(nRows, this, newTable);
        return newTable;
    }

    public Table last(int nRows) {
        nRows = Math.min(nRows, this.rowCount());
        Table newTable = this.emptyCopy(nRows);
        Rows.tail(nRows, this, newTable);
        return newTable;
    }

    public Table sortOn(String ... columnNames) {
        Sort key = null;
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.columnNames()) {
            names.add(name.toUpperCase());
        }
        for (String columnName : columnNames) {
            Sort.Order order;
            if (names.contains(columnName.toUpperCase())) {
                order = Sort.Order.ASCEND;
            } else {
                String prefix = columnName.substring(0, 1);
                columnName = columnName.substring(1, columnName.length());
                switch (prefix) {
                    case "+": {
                        order = Sort.Order.ASCEND;
                        break;
                    }
                    case "-": {
                        order = Sort.Order.DESCEND;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Column prefix: " + prefix + " is unknown.");
                    }
                }
            }
            if (key == null) {
                key = Table.first(columnName, order);
                continue;
            }
            key.next(columnName, order);
        }
        return this.sortOn(key);
    }

    public Table sortAscendingOn(String ... columnNames) {
        return this.sortOn(columnNames);
    }

    public Table sortDescendingOn(String ... columnNames) {
        Sort key = Table.getSort(columnNames);
        return this.sortOn(key);
    }

    public Table sortOn(Sort key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0);
        if (key.size() == 1) {
            IntComparator comparator = this.getComparator(key);
            return this.sortOn(comparator);
        }
        IntComparatorChain chain = this.getChain(key);
        return this.sortOn(chain);
    }

    public IntComparator getComparator(Sort key) {
        Iterator<Map.Entry<String, Sort.Order>> entries = key.iterator();
        Map.Entry<String, Sort.Order> sort = entries.next();
        IntComparator comparator = sort.getValue() == Sort.Order.ASCEND ? this.rowComparator(sort.getKey(), false) : this.rowComparator(sort.getKey(), true);
        return comparator;
    }

    private IntComparatorChain getChain(Sort key) {
        Iterator<Map.Entry<String, Sort.Order>> entries = key.iterator();
        Map.Entry<String, Sort.Order> sort = entries.next();
        IntComparator comparator = sort.getValue() == Sort.Order.ASCEND ? this.rowComparator(sort.getKey(), false) : this.rowComparator(sort.getKey(), true);
        IntComparatorChain chain = new IntComparatorChain(comparator);
        while (entries.hasNext()) {
            sort = entries.next();
            if (sort.getValue() == Sort.Order.ASCEND) {
                chain.addComparator(this.rowComparator(sort.getKey(), false));
                continue;
            }
            chain.addComparator(this.rowComparator(sort.getKey(), true));
        }
        return chain;
    }

    public Table sortOn(IntComparator rowComparator) {
        Table newTable = this.emptyCopy(this.rowCount());
        int[] newRows = this.rows();
        IntArrays.parallelQuickSort((int[])newRows, (IntComparator)rowComparator);
        Rows.copyRowsToTable(IntArrayList.wrap((int[])newRows), this, newTable);
        return newTable;
    }

    @VisibleForTesting
    public int[] rows() {
        int[] rowIndexes = new int[this.rowCount()];
        for (int i = 0; i < this.rowCount(); ++i) {
            rowIndexes[i] = i;
        }
        return rowIndexes;
    }

    private IntComparator rowComparator(String columnName, boolean reverse) {
        Column column = this.column(columnName);
        IntComparator rowComparator = column.rowComparator();
        if (reverse) {
            return ReversingIntComparator.reverse(rowComparator);
        }
        return rowComparator;
    }

    public Table selectWhere(Selection selection) {
        Table newTable = this.emptyCopy(selection.size());
        Rows.copyRowsToTable(selection, this, newTable);
        return newTable;
    }

    public BooleanColumn selectIntoColumn(String newColumnName, Selection selection) {
        return new BooleanColumn(newColumnName, selection, this.rowCount());
    }

    public Table selectWhere(Filter filter) {
        Selection map = filter.apply(this);
        Table newTable = this.emptyCopy(map.size());
        Rows.copyRowsToTable(map, this, newTable);
        return newTable;
    }

    public BooleanColumn selectIntoColumn(String newColumnName, Filter filter) {
        return new BooleanColumn(newColumnName, filter.apply(this), this.rowCount());
    }

    public ViewGroup groupBy(String ... columns) {
        return this.groupBy(this.columns(columns).toArray(new Column[columns.length]));
    }

    public ViewGroup groupBy(Column ... columns) {
        return new ViewGroup(this, columns);
    }

    public ViewGroup splitOn(String ... columns) {
        return this.groupBy(columns);
    }

    public ViewGroup splitOn(Column ... columns) {
        return this.groupBy(columns);
    }

    public String printHtml() {
        return HtmlTableWriter.write(this);
    }

    @Override
    public Table structure() {
        Table t = new Table("Structure of " + this.name());
        IntColumn index = new IntColumn("Index", this.columnCount());
        CategoryColumn columnName = new CategoryColumn("Column Name", this.columnCount());
        CategoryColumn columnType = new CategoryColumn("Column Type", this.columnCount());
        t.addColumn(index);
        t.addColumn(columnName);
        t.addColumn(columnType);
        columnName.addAll(this.columnNames());
        for (int i = 0; i < this.columnCount(); ++i) {
            Column column = this.columnList.get(i);
            index.append(i);
            columnType.add(column.type().name());
        }
        return t;
    }

    public Table selectRows(Collection<Integer> rows) {
        Table newTable = this.emptyCopy();
        Rows.copyRowsToTable(new IntArrayList(rows), this, newTable);
        return newTable;
    }

    public Table selectRows(int start, int end) {
        Table newTable = this.emptyCopy();
        IntArrayList rowsToKeep = new IntArrayList();
        for (int i = 0; i < this.rowCount(); ++i) {
            if (i < start || i > end) continue;
            rowsToKeep.add(i);
        }
        Rows.copyRowsToTable(rowsToKeep, this, newTable);
        return newTable;
    }

    public Table dropRows(Collection<Integer> rows) {
        Table newTable = this.emptyCopy();
        IntArrayList rowsToKeep = new IntArrayList();
        for (int i = 0; i < this.rowCount(); ++i) {
            rowsToKeep.add(i);
        }
        rowsToKeep.removeAll((IntCollection)new IntArrayList(rows));
        Rows.copyRowsToTable(rowsToKeep, this, newTable);
        return newTable;
    }

    public Table dropRows(int start, int end) {
        Table newTable = this.emptyCopy();
        IntArrayList rowsToKeep = new IntArrayList();
        for (int i = 0; i < this.rowCount(); ++i) {
            if (i >= start && i <= end) continue;
            rowsToKeep.add(i);
        }
        Rows.copyRowsToTable(rowsToKeep, this, newTable);
        return newTable;
    }

    public Table uniqueRecords() {
        Table sorted = this.sortOn(this.columnNames().toArray(new String[this.columns().size()]));
        Table temp = this.emptyCopy();
        for (int row = 0; row < this.rowCount(); ++row) {
            if (!temp.isEmpty() && Rows.compareRows(row, sorted, temp)) continue;
            Rows.appendRowToTable(row, sorted, temp);
        }
        return temp;
    }

    public Projection select(String ... columnName) {
        return new Projection(this, columnName);
    }

    @Override
    public Table removeColumns(Column ... columns) {
        this.columnList.removeAll(Arrays.asList(columns));
        return this;
    }

    public Column getAndRemoveColumn(String columnName) {
        Column c = this.column(columnName);
        this.removeColumns(c);
        return c;
    }

    public Column getAndRemoveColumn(int columnIndex) {
        Column c = this.column(columnIndex);
        this.removeColumns(c);
        return c;
    }

    public void retainColumns(Column ... columns) {
        List<Column> retained = Arrays.asList(columns);
        this.columnList.retainAll(retained);
    }

    public void retainColumns(String ... columnNames) {
        this.columnList.retainAll(this.columns(columnNames));
    }

    public SummaryFunction sum(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.sum);
    }

    public SummaryFunction mean(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.mean);
    }

    public SummaryFunction median(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.median);
    }

    public SummaryFunction variance(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.variance);
    }

    public SummaryFunction stdDev(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.stdDev);
    }

    public SummaryFunction count(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.count);
    }

    public SummaryFunction max(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.max);
    }

    public SummaryFunction min(String numericColumnName) {
        return new SummaryFunction(this, numericColumnName, AggregateFunctions.min);
    }

    public void append(Table tableToAppend) {
        for (Column column : this.columnList) {
            Column columnToAppend = tableToAppend.column(column.name());
            column.append(columnToAppend);
        }
    }

    public String save(String folder) {
        String storageFolder = "";
        try {
            storageFolder = StorageManager.saveTable(folder, this);
        }
        catch (IOException e) {
            System.err.println("Unable to save table in Tablesaw format");
            e.printStackTrace();
        }
        return storageFolder;
    }

    public double agg(String numericColumnName, AggregateFunction function) {
        Column column = this.column(numericColumnName);
        return function.agg(column.toDoubleArray());
    }

    public SummaryFunction summarize(String numericColumnName, AggregateFunction function) {
        return new SummaryFunction(this, numericColumnName, function);
    }

    public Table countBy(CategoryColumn column) {
        return column.countByCategory();
    }

    public int getFirst(Column column, String value) {
        int row = -1;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int r = (Integer)intIterator.next();
            if (!column.getString(r).equals(value)) continue;
            row = r;
            break;
        }
        return row;
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            public int nextInt() {
                return this.i++;
            }

            public int skip(int k) {
                return this.i + k;
            }

            public boolean hasNext() {
                return this.i < Table.this.rowCount();
            }

            public Integer next() {
                return this.i++;
            }
        };
    }
}

