/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;

public class LongIndex {
    private final Long2ObjectAVLTreeMap<IntArrayList> index;

    public LongIndex(LongColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Long2ObjectOpenHashMap tempMap = new Long2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            long value = column.get(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Long2ObjectAVLTreeMap((Long2ObjectMap)tempMap);
    }

    public LongIndex(DateTimeColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Long2ObjectOpenHashMap tempMap = new Long2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            long value = column.getLongInternal(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Long2ObjectAVLTreeMap((Long2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        LongIndex.addAllToSelection(list, selection);
        return selection;
    }

    public Selection atLeast(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap tail = this.index.tailMap(value + 1L);
        for (IntArrayList keys : tail.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap head = this.index.headMap(value + 1L);
        for (IntArrayList keys : head.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }
}

