/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntConvertibleColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.IntBiPredicate;
import tech.tablesaw.filtering.IntPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.IntMapUtils;
import tech.tablesaw.reducing.NumericReduceUtils;
import tech.tablesaw.sorting.IntComparisonUtil;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.ReverseIntComparator;
import tech.tablesaw.util.Selection;
import tech.tablesaw.util.Stats;

public class IntColumn
extends AbstractColumn
implements IntMapUtils,
NumericColumn,
IntConvertibleColumn {
    public static final int MISSING_VALUE = (Integer)ColumnType.INTEGER.getMissingValue();
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private static final int BYTE_SIZE = 4;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private IntArrayList data;
    final IntComparator comparator = new IntComparator(){

        public int compare(Integer i1, Integer i2) {
            return this.compare((int)i1, (int)i2);
        }

        public int compare(int i1, int i2) {
            int prim1 = IntColumn.this.get(i1);
            int prim2 = IntColumn.this.get(i2);
            return IntComparisonUtil.getInstance().compare(prim1, prim2);
        }
    };

    public IntColumn(String name) {
        this(name, new IntArrayList(128));
    }

    public IntColumn(String name, int initialSize) {
        this(name, new IntArrayList(initialSize));
    }

    public IntColumn(String name, IntArrayList data) {
        super(name);
        this.data = data;
    }

    public IntColumn(String name, int[] arr) {
        this(name, new IntArrayList(arr));
    }

    public IntColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new IntArrayList(metadata.getSize());
    }

    private static int convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return MISSING_VALUE;
        }
        Matcher matcher = COMMA_PATTERN.matcher(stringValue);
        return Integer.parseInt(matcher.replaceAll(""));
    }

    public IntArrayList data() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public ColumnType type() {
        return ColumnType.INTEGER;
    }

    public void append(int i) {
        this.data.add(i);
    }

    public void set(int index, int value) {
        this.data.set(index, value);
    }

    public Selection isLessThan(int i) {
        return this.select(isLessThan, i);
    }

    public Selection isGreaterThan(int i) {
        return this.select(isGreaterThan, i);
    }

    public Selection isGreaterThanOrEqualTo(int i) {
        return this.select(isGreaterThanOrEqualTo, i);
    }

    public Selection isLessThanOrEqualTo(int i) {
        return this.select(isLessThanOrEqualTo, i);
    }

    public Selection isNotEqualTo(int i) {
        return this.select(isNotEqualTo, i);
    }

    public Selection isEqualTo(int i) {
        return this.select(isEqualTo, i);
    }

    @Override
    public Selection isMissing() {
        return this.select(isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(isNotMissing);
    }

    public Selection isIn(int ... values) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        block0: for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            for (int v : values) {
                if (v != next) continue;
                bitmap.add(idx);
                continue block0;
            }
        }
        return bitmap;
    }

    public Selection isEqualTo(IntColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        IntIterator otherIterator = other.iterator();
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int otherNext;
            int next = (Integer)intListIterator.next();
            if (next == (otherNext = otherIterator.nextInt())) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Table summary() {
        return Stats.create(this).asTable();
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) != MISSING_VALUE) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        this.data.forEach(selection::add);
        return selection.size();
    }

    @Override
    public IntColumn unique() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        this.data.forEach(selection::add);
        return new IntColumn(this.name() + " Unique values", IntArrayList.wrap((int[])selection.toArray()));
    }

    public IntSet asSet() {
        return new IntOpenHashSet((IntCollection)this.data);
    }

    @Override
    public String getString(int row) {
        return String.valueOf(this.data.getInt(row));
    }

    @Override
    public IntColumn emptyCopy() {
        IntColumn column = new IntColumn(this.name(), 128);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public IntColumn emptyCopy(int rowSize) {
        IntColumn column = new IntColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        Arrays.parallelSort(this.data.elements());
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)ReverseIntComparator.instance());
    }

    @Override
    public IntColumn copy() {
        IntColumn column = new IntColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public void appendCell(String object) {
        try {
            this.append(IntColumn.convert(object));
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.name() + ": " + String.valueOf(object) + ": " + e.getMessage());
        }
    }

    @Override
    public int get(int index) {
        return this.data.getInt(index);
    }

    @Override
    public float getFloat(int index) {
        return this.data.getInt(index);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public int firstElement() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return MISSING_VALUE;
    }

    @Override
    public long sum() {
        return Math.round(NumericReduceUtils.sum.reduce(this.toDoubleArray()));
    }

    @Override
    public double product() {
        return NumericReduceUtils.product.reduce(this);
    }

    @Override
    public double mean() {
        return NumericReduceUtils.mean.reduce(this);
    }

    @Override
    public double median() {
        return NumericReduceUtils.median.reduce(this);
    }

    @Override
    public double quartile1() {
        return NumericReduceUtils.quartile1.reduce(this);
    }

    @Override
    public double quartile3() {
        return NumericReduceUtils.quartile3.reduce(this);
    }

    @Override
    public double percentile(double percentile) {
        return NumericReduceUtils.percentile(this.toDoubleArray(), percentile);
    }

    @Override
    public double range() {
        return NumericReduceUtils.range.reduce(this);
    }

    @Override
    public double max() {
        return (int)Math.round(NumericReduceUtils.max.reduce(this));
    }

    @Override
    public double min() {
        return (int)Math.round(NumericReduceUtils.min.reduce(this));
    }

    @Override
    public double variance() {
        return NumericReduceUtils.variance.reduce(this);
    }

    @Override
    public double populationVariance() {
        return NumericReduceUtils.populationVariance.reduce(this);
    }

    @Override
    public double standardDeviation() {
        return NumericReduceUtils.stdDev.reduce(this);
    }

    @Override
    public double sumOfLogs() {
        return NumericReduceUtils.sumOfLogs.reduce(this);
    }

    @Override
    public double sumOfSquares() {
        return NumericReduceUtils.sumOfSquares.reduce(this);
    }

    @Override
    public double geometricMean() {
        return NumericReduceUtils.geometricMean.reduce(this);
    }

    @Override
    public double quadraticMean() {
        return NumericReduceUtils.quadraticMean.reduce(this);
    }

    @Override
    public double kurtosis() {
        return NumericReduceUtils.kurtosis.reduce(this);
    }

    @Override
    public double skewness() {
        return NumericReduceUtils.skewness.reduce(this);
    }

    public Selection isPositive() {
        return this.select(isPositive);
    }

    public Selection isNegative() {
        return this.select(isNegative);
    }

    public Selection isNonNegative() {
        return this.select(isNonNegative);
    }

    public Selection isZero() {
        return this.select(isZero);
    }

    public Selection isEven() {
        return this.select(isEven);
    }

    public Selection isOdd() {
        return this.select(isOdd);
    }

    public FloatArrayList toFloatArray() {
        FloatArrayList output = new FloatArrayList(this.data.size());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            output.add((float)aData);
        }
        return output;
    }

    @Override
    public int[] toIntArray() {
        int[] output = new int[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getInt(i);
        }
        return output;
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getInt(i);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            builder.append(String.valueOf(i));
            builder.append('\n');
        }
        return builder.toString();
    }

    public String toString() {
        return "Int column: " + this.name();
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        IntColumn intColumn = (IntColumn)column;
        for (int i = 0; i < intColumn.size(); ++i) {
            this.append(intColumn.get(i));
        }
    }

    public IntColumn selectIf(IntPredicate predicate) {
        IntColumn column = this.emptyCopy();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            column.append(next);
        }
        return column;
    }

    public IntColumn select(Selection selection) {
        IntColumn column = this.emptyCopy();
        IntIterator intIterator = selection.iterator();
        while (intIterator.hasNext()) {
            Integer next = (Integer)intIterator.next();
            column.append(this.data.getInt(next.intValue()));
        }
        return column;
    }

    public Selection select(IntPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public Selection select(IntBiPredicate predicate, int value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            int next = this.data.getInt(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    public long sumIf(IntPredicate predicate) {
        long sum = 0L;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            sum += (long)next;
        }
        return sum;
    }

    public long countIf(IntPredicate predicate) {
        long count = 0L;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int next = intIterator.nextInt();
            if (!predicate.test(next)) continue;
            ++count;
        }
        return count;
    }

    public IntColumn remainder(IntColumn column2) {
        IntColumn result = new IntColumn(this.name() + " % " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) % column2.get(r));
        }
        return result;
    }

    public IntColumn add(IntColumn column2) {
        IntColumn result = new IntColumn(this.name() + " + " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + column2.get(r));
        }
        return result;
    }

    public IntColumn addToEach(int value) {
        IntColumn result = new IntColumn(this.name() + " + " + value, this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) + value);
        }
        return result;
    }

    public IntColumn subtract(IntColumn column2) {
        IntColumn result = new IntColumn(this.name() + " - " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) - column2.get(r));
        }
        return result;
    }

    public IntColumn multiply(IntColumn column2) {
        IntColumn result = new IntColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append(this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn multiply(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " * " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) * column2.get(r));
        }
        return result;
    }

    public FloatColumn divide(FloatColumn column2) {
        FloatColumn result = new FloatColumn(this.name() + " / " + column2.name(), this.size());
        for (int r = 0; r < this.size(); ++r) {
            result.append((float)this.get(r) / column2.get(r));
        }
        return result;
    }

    public IntArrayList top(int n) {
        IntArrayList top = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)ReverseIntComparator.instance());
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return top;
    }

    public IntArrayList bottom(int n) {
        IntArrayList bottom = new IntArrayList();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return bottom;
    }

    @NotNull
    public IntIterator iterator() {
        return this.data.iterator();
    }

    public Stats stats() {
        FloatColumn values = new FloatColumn(this.name(), this.toFloatArray());
        return Stats.create(values);
    }

    public boolean contains(int i) {
        return this.data.contains(i);
    }

    @Override
    public int byteSize() {
        return 4;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(4).putInt(this.get(rowNumber)).array();
    }

    @Override
    public IntColumn difference() {
        IntColumn returnValue = new IntColumn(this.name(), this.size());
        returnValue.append(MISSING_VALUE);
        for (int current = 0; current < this.size(); ++current) {
            if (current + 1 >= this.size()) continue;
            int currentValue = this.get(current);
            int nextValue = this.get(current + 1);
            if (current == MISSING_VALUE || nextValue == MISSING_VALUE) {
                returnValue.append(MISSING_VALUE);
                continue;
            }
            returnValue.append(nextValue - currentValue);
        }
        return returnValue;
    }
}

