/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.beakerx;

import com.google.common.collect.Lists;
import com.twosigma.beakerx.jvm.object.OutputCell;
import com.twosigma.beakerx.table.TableDisplay;
import java.util.List;
import java.util.Map;
import jupyter.Displayer;
import jupyter.Displayers;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class TablesawDisplayer {
    private TablesawDisplayer() {
    }

    public static void register() {
        TablesawDisplayer.registerTable();
        TablesawDisplayer.registerColumns();
    }

    public static void registerTable() {
        Displayers.register(Table.class, (Displayer)new Displayer<Table>(){

            public Map<String, String> display(Table table) {
                new TableDisplay(table.rowCount(), table.columnCount(), table.columnNames(), (columnIndex, rowIndex) -> table.getUnformatted(rowIndex, columnIndex)).display();
                return OutputCell.DISPLAYER_HIDDEN;
            }
        });
    }

    public static void registerColumns() {
        Displayers.register(Column.class, (Displayer)new Displayer<Column>(){

            public Map<String, String> display(Column column) {
                new TableDisplay(column.size(), 1, (List)Lists.newArrayList((Object[])new String[]{column.name()}), (columnIndex, rowIndex) -> column.getUnformattedString(rowIndex)).display();
                return OutputCell.DISPLAYER_HIDDEN;
            }
        });
    }
}

