/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core.components;

import android.content.Context;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.core.components.SKListVC;
import tech.skot.core.components.SKListViewProxy;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004*+,-BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0010J2\u0010!\u001a\u00020\u00192*\u0010\u001a\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00180\u00150\u0014J\b\u0010\"\u001a\u00020\u0019H\u0016J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u0004\u0018\u00010%J\u000e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rl\u0010\u001a\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00180\u00150\u00142*\u0010\u0013\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u0017\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00180\u00150\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ltech/skot/core/components/SKListView;", "Ltech/skot/core/components/SKComponentView;", "Landroidx/recyclerview/widget/RecyclerView;", "layoutMode", "Ltech/skot/core/components/SKListVC$LayoutMode;", "reverse", "", "animate", "animateItem", "proxy", "Ltech/skot/core/components/SKListViewProxy;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "recyclerView", "(Ltech/skot/core/components/SKListVC$LayoutMode;ZZZLtech/skot/core/components/SKListViewProxy;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Landroidx/recyclerview/widget/RecyclerView;)V", "adapter", "Ltech/skot/core/components/SKListView$Adapter;", "newVal", "", "Lkotlin/Triple;", "Ltech/skot/core/components/SKComponentViewProxy;", "", "Lkotlin/Function0;", "", "items", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "mapProxyIndexComponentViewImpl", "", "onItems", "onRecycle", "restoreState", "state", "Landroid/os/Parcelable;", "saveState", "scrollToPosition", "scrollRequest", "Ltech/skot/core/components/SKListViewProxy$ScrollRequest;", "Adapter", "CenterSmoothScroller", "DiffCallBack", "ViewHolder", "viewlegacy_release"})
@SourceDebugExtension(value={"SMAP\nSKListView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SKListView.kt\ntech/skot/core/components/SKListView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1855#2,2:218\n1855#2:220\n1747#2,3:221\n1856#2:224\n*S KotlinDebug\n*F\n+ 1 SKListView.kt\ntech/skot/core/components/SKListView\n*L\n64#1:218,2\n71#1:220\n72#1:221,3\n71#1:224\n*E\n"})
public final class SKListView
extends SKComponentView<RecyclerView> {
    @NotNull
    private final RecyclerView recyclerView;
    @NotNull
    private final Map<SKComponentViewProxy<?>, SKComponentView<?>> mapProxyIndexComponentViewImpl;
    @NotNull
    private final Adapter adapter;
    @NotNull
    private List<? extends Triple<? extends SKComponentViewProxy<?>, ? extends Object, ? extends Function0<Unit>>> items;

    public SKListView(@NotNull SKListVC.LayoutMode layoutMode, boolean reverse, boolean animate, boolean animateItem, @NotNull SKListViewProxy proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)layoutMode, (String)"layoutMode");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        super(proxy, activity, fragment, recyclerView);
        this.recyclerView = recyclerView;
        this.mapProxyIndexComponentViewImpl = new LinkedHashMap();
        this.adapter = new Adapter();
        this.items = CollectionsKt.emptyList();
        SKListVC.LayoutMode layoutMode2 = layoutMode;
        if (layoutMode2 instanceof SKListVC.LayoutMode.Linear) {
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), ((SKListVC.LayoutMode.Linear)layoutMode).getVertical() ? 1 : 0, reverse));
        } else if (layoutMode2 instanceof SKListVC.LayoutMode.Grid) {
            this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), ((SKListVC.LayoutMode.Grid)layoutMode).getNbColumns(), ((SKListVC.LayoutMode.Grid)layoutMode).getVertical() ? 1 : 0, reverse));
        } else if (Intrinsics.areEqual((Object)layoutMode2, (Object)SKListVC.LayoutMode.Manual.INSTANCE)) {
            // empty if block
        }
        if (!animate) {
            this.recyclerView.setItemAnimator(null);
        } else if (!animateItem) {
            RecyclerView.ItemAnimator itemAnimator = this.recyclerView.getItemAnimator();
            SimpleItemAnimator simpleItemAnimator = itemAnimator instanceof SimpleItemAnimator ? (SimpleItemAnimator)itemAnimator : null;
            if (simpleItemAnimator != null) {
                simpleItemAnimator.setSupportsChangeAnimations(false);
            }
        }
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    @Override
    public void onRecycle() {
        super.onRecycle();
        Iterable $this$forEach$iv = this.mapProxyIndexComponentViewImpl.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SKComponentView it = (SKComponentView)element$iv;
            boolean bl = false;
            it.onRecycle();
        }
    }

    @NotNull
    public final List<Triple<SKComponentViewProxy<?>, Object, Function0<Unit>>> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<? extends Triple<? extends SKComponentViewProxy<?>, ? extends Object, ? extends Function0<Unit>>> newVal) {
        Intrinsics.checkNotNullParameter(newVal, (String)"newVal");
        Iterable $this$forEach$iv = this.items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            Triple proxy;
            block4: {
                proxy = (Triple)element$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = newVal;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Triple it = (Triple)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)proxy.getFirst())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
            this.mapProxyIndexComponentViewImpl.remove(proxy.getFirst());
        }
        DiffCallBack diffCallBack = new DiffCallBack(this.items, newVal);
        this.items = newVal;
        DiffUtil.calculateDiff((DiffUtil.Callback)diffCallBack, (boolean)true).dispatchUpdatesTo((RecyclerView.Adapter)this.adapter);
    }

    public final void onItems(@NotNull List<? extends Triple<? extends SKComponentViewProxy<?>, ? extends Object, ? extends Function0<Unit>>> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.setItems(items);
    }

    @Nullable
    public final Parcelable saveState() {
        RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
        return layoutManager != null ? layoutManager.onSaveInstanceState() : null;
    }

    public final void restoreState(@NotNull Parcelable state) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
            if (layoutManager == null) break block0;
            layoutManager.onRestoreInstanceState(state);
        }
    }

    public final void scrollToPosition(@NotNull SKListViewProxy.ScrollRequest scrollRequest) {
        block2: {
            SKListVC.ScrollMode scrollMode;
            block3: {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)scrollRequest, (String)"scrollRequest");
                    scrollMode = scrollRequest.getMode();
                    if (!Intrinsics.areEqual((Object)scrollMode, (Object)SKListVC.ScrollMode.StartToStart.INSTANCE)) break block1;
                    ((RecyclerView)this.getBinding()).post(() -> SKListView.scrollToPosition$lambda$3(this, scrollRequest));
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)scrollMode, (Object)SKListVC.ScrollMode.Visible.INSTANCE)) break block3;
                if (this.adapter.getItemCount() <= scrollRequest.getPosition()) break block2;
                ((RecyclerView)this.getBinding()).smoothScrollToPosition(scrollRequest.getPosition());
                break block2;
            }
            if (!Intrinsics.areEqual((Object)scrollMode, (Object)SKListVC.ScrollMode.Center.INSTANCE)) break block2;
            RecyclerView.LayoutManager layoutManager = ((RecyclerView)this.getBinding()).getLayoutManager();
            LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
            if (linearLayoutManager != null) {
                RecyclerView.LayoutManager $this$scrollToPosition_u24lambda_u244 = layoutManager = linearLayoutManager;
                boolean bl = false;
                Context context = this.recyclerView.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"recyclerView.context");
                CenterSmoothScroller centerSmotthScroller = new CenterSmoothScroller(context);
                centerSmotthScroller.setTargetPosition(scrollRequest.getPosition());
                $this$scrollToPosition_u24lambda_u244.startSmoothScroll((RecyclerView.SmoothScroller)centerSmotthScroller);
            }
        }
    }

    private static final void scrollToPosition$lambda$3(SKListView this$0, SKListViewProxy.ScrollRequest $scrollRequest) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$scrollRequest, (String)"$scrollRequest");
            RecyclerView.LayoutManager layoutManager = ((RecyclerView)this$0.getBinding()).getLayoutManager();
            LinearLayoutManager linearLayoutManager = layoutManager instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager : null;
            if (linearLayoutManager == null) break block0;
            linearLayoutManager.scrollToPositionWithOffset($scrollRequest.getPosition(), 0);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u001c\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u001c\u0010\f\u001a\u00060\u0002R\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0014\u0010\u0010\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0002R\u00020\u0003H\u0016\u00a8\u0006\u0011"}, d2={"Ltech/skot/core/components/SKListView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Ltech/skot/core/components/SKListView$ViewHolder;", "Ltech/skot/core/components/SKListView;", "(Ltech/skot/core/components/SKListView;)V", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewRecycled", "viewlegacy_release"})
    public final class Adapter
    extends RecyclerView.Adapter<ViewHolder> {
        @NotNull
        public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new ViewHolder(viewType, parent);
        }

        public int getItemViewType(int position) {
            Integer n = ((SKComponentViewProxy)SKListView.this.getItems().get(position).getFirst()).getLayoutId();
            if (n == null) {
                throw new IllegalStateException(Reflection.getOrCreateKotlinClass(SKListView.this.getItems().get(position).getFirst().getClass()).getSimpleName() + " can't be in a recyclerview");
            }
            return n;
        }

        public int getItemCount() {
            return SKListView.this.getItems().size();
        }

        public void onBindViewHolder(@NotNull ViewHolder holder, int position) {
            Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
            Triple<SKComponentViewProxy<?>, Object, Function0<Unit>> triple = SKListView.this.getItems().get(position);
            SKListView sKListView = SKListView.this;
            Triple<SKComponentViewProxy<?>, Object, Function0<Unit>> proxy = triple;
            boolean bl = false;
            SKComponentViewProxy sKComponentViewProxy = (SKComponentViewProxy)proxy.getFirst();
            SKActivity sKActivity = sKListView.getActivity();
            Fragment fragment = sKListView.getFragment();
            View view = holder.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
            SKComponentView componentViewImpl = sKComponentViewProxy.bindToItemView(sKActivity, fragment, view);
            holder.setComponentView(componentViewImpl);
            sKListView.mapProxyIndexComponentViewImpl.put(proxy.getFirst(), componentViewImpl);
        }

        public void onViewRecycled(@NotNull ViewHolder holder) {
            Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            SKComponentView<?> sKComponentView = holder.getComponentView();
            if (sKComponentView != null) {
                sKComponentView.onRecycle();
            }
            holder.setComponentView(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B]\u0012*\u0010\u0002\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00040\u0003\u0012*\u0010\t\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016R2\u0010\t\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0002\u001a&\u0012\"\u0012 \u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/skot/core/components/SKListView$DiffCallBack;", "Landroidx/recyclerview/widget/DiffUtil$Callback;", "oldList", "", "Lkotlin/Triple;", "Ltech/skot/core/components/SKComponentViewProxy;", "", "Lkotlin/Function0;", "", "newList", "(Ljava/util/List;Ljava/util/List;)V", "areContentsTheSame", "", "oldItemPosition", "", "newItemPosition", "areItemsTheSame", "getNewListSize", "getOldListSize", "viewlegacy_release"})
    public static final class DiffCallBack
    extends DiffUtil.Callback {
        @NotNull
        private final List<Triple<SKComponentViewProxy<?>, Object, Function0<Unit>>> oldList;
        @NotNull
        private final List<Triple<SKComponentViewProxy<?>, Object, Function0<Unit>>> newList;

        public DiffCallBack(@NotNull List<? extends Triple<? extends SKComponentViewProxy<?>, ? extends Object, ? extends Function0<Unit>>> oldList, @NotNull List<? extends Triple<? extends SKComponentViewProxy<?>, ? extends Object, ? extends Function0<Unit>>> newList) {
            Intrinsics.checkNotNullParameter(oldList, (String)"oldList");
            Intrinsics.checkNotNullParameter(newList, (String)"newList");
            this.oldList = oldList;
            this.newList = newList;
        }

        public int getOldListSize() {
            return this.oldList.size();
        }

        public int getNewListSize() {
            return this.newList.size();
        }

        public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
            Triple<SKComponentViewProxy<?>, Object, Function0<Unit>> oldItem = this.oldList.get(oldItemPosition);
            Triple<SKComponentViewProxy<?>, Object, Function0<Unit>> newItem = this.newList.get(newItemPosition);
            return Intrinsics.areEqual((Object)((SKComponentViewProxy)oldItem.getFirst()).getLayoutId(), (Object)((SKComponentViewProxy)newItem.getFirst()).getLayoutId()) && Intrinsics.areEqual((Object)oldItem.getSecond(), (Object)newItem.getSecond());
        }

        public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
            return Intrinsics.areEqual((Object)this.oldList.get(oldItemPosition).getFirst(), (Object)this.newList.get(newItemPosition).getFirst());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Ltech/skot/core/components/SKListView$CenterSmoothScroller;", "Landroidx/recyclerview/widget/LinearSmoothScroller;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "calculateDtToFit", "", "viewStart", "viewEnd", "boxStart", "boxEnd", "snapPreference", "viewlegacy_release"})
    private static final class CenterSmoothScroller
    extends LinearSmoothScroller {
        public CenterSmoothScroller(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
        }

        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            return boxStart + (boxEnd - boxStart) / 2 - (viewStart + (viewEnd - viewStart) / 2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ltech/skot/core/components/SKListView$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "idLayout", "", "parent", "Landroid/view/ViewGroup;", "(Ltech/skot/core/components/SKListView;ILandroid/view/ViewGroup;)V", "componentView", "Ltech/skot/core/components/SKComponentView;", "getComponentView", "()Ltech/skot/core/components/SKComponentView;", "setComponentView", "(Ltech/skot/core/components/SKComponentView;)V", "viewlegacy_release"})
    public final class ViewHolder
    extends RecyclerView.ViewHolder {
        @Nullable
        private SKComponentView<?> componentView;

        public ViewHolder(@NotNull int idLayout, ViewGroup parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(LayoutInflater.from((Context)parent.getContext()).inflate(idLayout, parent, false));
        }

        @Nullable
        public final SKComponentView<?> getComponentView() {
            return this.componentView;
        }

        public final void setComponentView(@Nullable SKComponentView<?> sKComponentView) {
            this.componentView = sKComponentView;
        }
    }
}

